#==============================================================================
#  Event_Handling_Module
#------------------------------------------------------------------------------
# CxgnhOW[
# Copyright (C) 2005 fukuyama
#==============================================================================

module Event_Handling_Module
  #--------------------------------------------------------------------------
  # nh
  #--------------------------------------------------------------------------
  class Handler
    attr_reader :name    # nh
    def initialize(name, trigger, handler)
      @name = name
      @trigger = trigger
      @handler = handler
    end
    def execute
      if @trigger.call
        @handler.call
        return true
      end
      return false
    end
  end

  #---------------------------------------------------------------------------
  # 
  #---------------------------------------------------------------------------
  def initialize(*arg)
    super(*arg)
    setup_default_handler
  end
  #---------------------------------------------------------------------------
  # ftHgnh[̍쐬
  #---------------------------------------------------------------------------
  def setup_default_handler
    handlers = {
      Input::A => 'input_a',
      Input::B => 'input_b',
      Input::C => 'input_c',
      Input::X => 'input_x',
      Input::Y => 'input_y',
      Input::Z => 'input_z',
      Input::LEFT  => 'input_left',
      Input::RIGHT => 'input_right',
      Input::UP    => 'input_up',
      Input::DOWN  => 'input_down',
    }
    handlers.each do |code,method_name|
      if self.class.method_defined?(method_name)
        add_input_handler(code,method_name)
      end
    end
    if self.class.method_defined?('active_event')
      @prev_active = false
      trigger = proc do
        if (self.active and @prev_active) or ((not self.active) and (not @prev_active))
          @prev_active = self.active
          return false
        end
        @prev_active = self.active
        return true
      end
      add_handler('active_event',trigger,'active_event')
    end
  end
  #---------------------------------------------------------------------------
  # nh[̒ǉ
  #---------------------------------------------------------------------------
  def add_handler(name,trigger,handler)
    @_handlers = {} if @_handlers.nil?
    @_handlers[name] = [] if @_handlers[name].nil?
    case handler
    when Symbol
      handler = method handler
    when String
      handler = method handler
    end
    @_handlers[name].push Handler.new(name,trigger,handler)
  end
  #---------------------------------------------------------------------------
  # Cvbgnh[̒ǉ
  #---------------------------------------------------------------------------
  def add_input_handler(code,handler)
    name = 'input' + code.to_s
    trigger = proc do
      if not self.active
        return false
      end
      if Input.repeat?(code)
        return true
      end
      return false
    end
    @_input_handlers = {} if @_input_handlers.nil?
    @_input_handlers[name] = [] if @_input_handlers[name].nil?
    case handler
    when Symbol
      handler = method handler
    when String
      handler = method handler
    end
    @_input_handlers[name].push Handler.new(name,trigger,handler)
  end
  #---------------------------------------------------------------------------
  # nh[̍폜
  #---------------------------------------------------------------------------
  def remove_handler(name)
    @_handlers.delete(name)
  end
  #---------------------------------------------------------------------------
  # Cvbgnh[̍폜
  #---------------------------------------------------------------------------
  def remove_input_handler(code)
    @_input_handlers.delete('input' + code.to_s)
  end
  #---------------------------------------------------------------------------
  # XV
  #---------------------------------------------------------------------------
  def update
    return if self.disposed?
    super
    return if self.disposed?
    update_all_handler if not self.is_a? Window_Tree_Module
  end
  #---------------------------------------------------------------------------
  # nh[̍XV
  #---------------------------------------------------------------------------
  def _update_handler(handlers)
    if not handlers.nil?
      handlers.each do |name,handlers|
        handlers.each do |handler|
          if handler.execute
            return
          end
          return if self.disposed?
        end
      end
    end
  end
  def update_all_handler
    update_handler
    update_input_handler
  end
  def update_handler
    _update_handler(@_handlers)
  end
  def update_input_handler
    _update_handler(@_input_handlers)
  end
  #---------------------------------------------------------------------------
  # nh[̍XViꕔj
  #---------------------------------------------------------------------------
  def update_sub_handler
    if not @_handlers.nil?
      @_handlers.each do |name,handlers|
        if yield(name)
          handlers.each do |handler|
            if handler.execute
              return
            end
            return if self.disposed?
          end
        end
      end
    end
  end
end
