#==============================================================================
#  Markup_Text_Module
#------------------------------------------------------------------------------
# }[NAbveLXgW[
# Copyright (C) 2005 fukuyama
#==============================================================================
#
# ̃W[gꍇ́A
# String_Replace_ModuleStringOperation_Module邱
# BitmapWindowSpriteincludełi\j
#
#==============================================================================

module Markup_Text_Module
  attr_accessor :line_height
  DEFAULT_LINE_HEIGHT = 32

  #----------------------------------------------------------------------------
  # ϊ`
  #----------------------------------------------------------------------------
  def draw_markup_text(*arg)
    @line_height = DEFAULT_LINE_HEIGHT if @line_height.nil?
    case self
    when Bitmap
      bmp = self
    when Window
      bmp = self.contents
    when Sprite
      bmp = self.bitmap
    else
      return
    end
    case arg.size
    when 1
      if arg[0].is_a?(String)
        src_text = arg[0]
        (x,y) = 0,0
      end
    when 3
      if arg[0].is_a?(Fixnum) and arg[1].is_a?(Fixnum)
        (x,y) = arg[0],arg[1]
      end
      if arg[2].is_a?(String)
        src_text = arg[2]
      end
    end
    text = markup_replace(src_text)
    text.split(/\n/).each do |line|
      while line.size != 0
        x,y,line = markup_operation(x,y,line)
        c = line.slice!(/./m)
        w = bmp.text_size(c).width
        # s
        if bmp.rect.width < (x + w)
          x = 0
          y += @line_height
        end
        bmp.draw_text(x,y,w,@line_height,c)
        x += w
      end
      x = 0
      y += @line_height
    end
  end
  private :draw_markup_text
end
