/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.flex.manager{
	
	import flash.display.DisplayObject;
	import flash.events.MouseEvent;
	import flash.utils.Dictionary;
	
	import mx.containers.TitleWindow;
	import mx.core.Application;
	import mx.core.IFlexDisplayObject;
	import mx.events.FlexEvent;
	import mx.managers.PopUpManager;
	
	/**
	 * <p>[概 要]</p>
	 * ポップアップされたコンポーネント等を管理するクラスです.
	 * 
	 * <p>[詳 細]</p>
	 * 
	 * <p>[備 考]</p>
	 * 
	 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
	 * @author Project Reffi
	 */
	public class ComponentManager{
		
        private static var windowManager:ComponentManager;
        
	    private var _popUpPanels:Dictionary = new Dictionary();
		
		/**
		 * <p>[概 要]</p>
		 * 管理されているウィンドウ一覧を取得します.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 */
		public function get popUpPanels():Dictionary{
			return _popUpPanels;
		}
		
		/**
		 * <p>[概 要]</p>
		 * インスタンスを取得します.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 */
		public static function getInstance():ComponentManager{
			if(!windowManager || windowManager == null){
				windowManager = new ComponentManager();
			}
			return windowManager;
		}

		/**
		 * <p>[概 要]</p>
		 * 指定したウィンドウをマネージャ管理下に追加します.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param windowName ウィンドウID名
		 * @param window ウィンドウインスタンス
		 * @param modal モーダル制御フラグ
		 * @param centered センタリングフラグ
		 */
		public function addPopUp(windowName:String, window:IFlexDisplayObject, parent:DisplayObject = null, modal:Boolean = false, centered:Boolean = false):void {
			if (parent == null) {
				parent = Application.application as DisplayObject;
			}
			PopUpManager.addPopUp(window, parent, modal);
			if (centered) {
				PopUpManager.centerPopUp(window);
			}
			
			var popUpList:Array = null;
			
			if(popUpPanels.hasOwnProperty(windowName)){
				popUpList = popUpPanels[windowName];
			}else{
				popUpList = new Array();
				this.popUpPanels[windowName] = popUpList;
			}

			DisplayObject(window).addEventListener(FlexEvent.CREATION_COMPLETE, function():void{

				if(modal == false){
					window.addEventListener(MouseEvent.CLICK, function(event:MouseEvent):void {
						
						var winObj:DisplayObject = window as DisplayObject;
						if (winObj.parent == null) {
							return;
						}
						var maxIndex:Number = winObj.parent.numChildren;
						var moveIndex:Number = 1;
						var frontTarget:DisplayObject;
						while(moveIndex <= maxIndex) {
							frontTarget = winObj.parent.getChildAt(maxIndex - moveIndex);
							if (frontTarget is TitleWindow) {
								break;
							} else {
								moveIndex++;
							}
						}
						winObj.parent.setChildIndex(winObj, maxIndex - moveIndex);
					});
				}
			});
			
			popUpList.push(window);
		}
		
		/**
		 * <p>[概 要]</p>
		 * 重複を許可しないウィンドウをマネージャ管理下に追加します.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param windowName ウィンドウID名
		 * @param window ウィンドウインスタンス
		 * @param modal モーダル制御フラグ
		 * @param centered センタリングフラグ
		 * 
		 */
		public function addSingletonPopUp(windowName:String, window:IFlexDisplayObject, parent:DisplayObject = null, modal:Boolean = false, centered:Boolean = false):void {
			removePopUp(windowName);
			addPopUp(windowName, window, parent, modal, centered);
		}
			
		/**
		 * <p>[概 要]</p>
		 * 管理されているウィンドウをすべてRemoveします.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 */
		public function removeAllPopUp():Boolean{
			var ret:Boolean = true;

			for(var windowName:String in popUpPanels){
				var removed:Boolean = removePopUp(windowName);
				ret = ret && removed;
			}
			
			return ret;
		}
			
		/**
		 * <p>[概 要]</p>
		 * 既にマネージャ管理下に同名のウィンドウが存在するかをチェックします.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param windowName ウィンドウID名
		 */
		public function isExistPopUp(windowName:String):Boolean{				
			return popUpPanels.hasOwnProperty(windowName);
		}
		
		/**
		 * <p>[概 要]</p>
		 * マネージャ管理下の指定されたウィンドウID名のウィンドウをRemoveします.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param windowName ウィンドウID名
		 */
		public function removePopUp(windowName:String):Boolean{
			var ret:Boolean = false;
			
			if(popUpPanels.hasOwnProperty(windowName)){
				var windowGroup:Array = popUpPanels[windowName];
				
				for(var index:int = windowGroup.length -1; index >=0; index--){
					var window:IFlexDisplayObject = windowGroup[index];
					PopUpManager.removePopUp(window);
				}

				delete popUpPanels[windowName];
				ret = true;
			}
			
			return ret;
		}

		/**
		 * <p>[概 要]</p>
		 * マネージャ管理下の指定されたウィンドウID名のウィンドウを取得します.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param windowName ウィンドウID名
		 * @return ウィンドウIDで管理されているウィンドウ配列
		 */
		public function getPopUp(windowName:String):Array{
			var ret:Array = null;
			
			if(popUpPanels.hasOwnProperty(windowName)){
				ret = popUpPanels[windowName];
			}
			
			return ret;
		}

		/**
		 * <p>[概 要]</p>
		 * マネージャ管理下の指定されたウィンドウID名の重複を許可しないウィンドウを取得します.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param windowName ウィンドウID名
		 * @return ウィンドウIDで管理されているウィンドウ配列
		 */
		public function getSingletonPopUp(windowName:String):IFlexDisplayObject {
			var ret:IFlexDisplayObject = null;
			
			if(popUpPanels.hasOwnProperty(windowName)){
				var windows:Array = popUpPanels[windowName];
				ret = windows[0];
			}
			
			return ret;
		}
			
		/**
		 * <p>[概 要]</p>
		 * マネージャ管理下の指定されたウィンドウID名のウィンドウを最前面に表示させます.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param windowName ウィンドウID名
		 */
		public function bringToFront(windowName:String):Boolean{
			var ret:Boolean = false;
			
			if(popUpPanels.hasOwnProperty(windowName)){
				var windows:Array = popUpPanels[windowName]
				for(var index:int = 0; index < windows.length; index++){
					PopUpManager.bringToFront(windows[index]);
				}
				
			    ret = true;
			}
			
			return ret;
		}
		
		/**
		 * <p>[概 要]</p>
		 * マネージャ管理下の指定されたウィンドウID名のウィンドウを画面中央に表示させます.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param windowName ウィンドウID名
		 */
		public function centerPopup(windowName:String):Boolean{
			var ret:Boolean = false;
			
			if(popUpPanels.hasOwnProperty(windowName)){
				var windows:Array = popUpPanels[windowName]
				for(var index:int = 0; index < windows.length; index++){
					PopUpManager.centerPopUp(windows[index]);
				}
				
			    ret = true;
			}
			
			return ret;
		}
	}
}
