// -*-c++-*-

/*!
  \file player_type_dialog.cpp
  \brief player type list ialog class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qt.h>

#include "player_type_dialog.h"

#include "main_data.h"

#include <rcsc/common/server_param.h>
#include <rcsc/common/player_type.h>

#include <iostream>
#include <cstdio>

class NumberListViewItem
    : public QListViewItem {
private:

public:
    NumberListViewItem( QListView * parent )
        : QListViewItem( parent )
      { }

    virtual
    int compare( QListViewItem * i, int col, bool ascending ) const
      {
          double lhs = 0.0;
          double rhs = 0.0;
          std::sscanf( this->key( col, ascending ).ascii(), " %lf ", &lhs );
          std::sscanf( i->key( col, ascending ).ascii(), " %lf ", &rhs );

          return ( lhs < rhs ? -1
                   : lhs > rhs ? 1
                   : 0 );
      }
};


/*-------------------------------------------------------------------*/
/*!

 */
PlayerTypeDialog::PlayerTypeDialog( QWidget * parent,
                                    const MainData & main_data )
    : QDialog( parent )
    , M_main_data( main_data )
{
    //this->setWindowTitle( tr( "Player Type List" ) );
    this->setCaption( tr( "Player Type List" ) );

    //QFont font = this->font();
    //font.setPointSize( 8 );
    //this->setFont( font );

    createTable();
}

/*-------------------------------------------------------------------*/
/*!

 */
PlayerTypeDialog::~PlayerTypeDialog()
{
    //std::cerr << "delete PlayerTypeDialog" << std::endl;
}

/*-------------------------------------------------------------------*/
/*!

 */
void
PlayerTypeDialog::createTable()
{
    QBoxLayout * layout = new QBoxLayout( this, QBoxLayout::LeftToRight );

    M_player_type_table = new QListView( this );
    //M_player_type_table->setResizeMode( QListView::AllColumns );
    M_player_type_table->setMinimumWidth( 640 );
    M_player_type_table->setHScrollBarMode( QScrollView::AlwaysOff );
    M_player_type_table->setVScrollBarMode( QScrollView::AlwaysOff );

    //QFont font = M_player_type_table->font();
    //font.setPointSize( 8 );
    //M_player_type_table->setFont( font );

    QFontMetrics metrics = M_player_type_table->fontMetrics();

    {
        int col = 0;
        M_player_type_table->addColumn( tr( "id" ),
                                        metrics.width( tr( "0" ) ) + 12 );
        M_player_type_table->setColumnWidthMode( col, QListView::Maximum );
        M_player_type_table->setColumnAlignment( col, Qt::AlignLeft );
        ++col;
//         //
//         M_player_type_table->addColumn( tr( "Size" ),
//                                         metrics.width( tr( "0.300" ) ) + 12 );
//         M_player_type_table->setColumnWidthMode( col, QListView::Maximum );
//         M_player_type_table->setColumnAlignment( col, Qt::AlignLeft );
//         ++col;
        //
        M_player_type_table->addColumn( tr( "Speed Real/Max" ),
                                        metrics.width( tr( "1.000 / 1.200" ) ) + 12 );
        M_player_type_table->setColumnWidthMode( col, QListView::Maximum );
        M_player_type_table->setColumnAlignment( col, Qt::AlignLeft );
        ++col;
        //
        M_player_type_table->addColumn( tr( "AccStep" ),
                                        metrics.width( tr( "0" ) ) + 12 );
        M_player_type_table->setColumnWidthMode( col, QListView::Maximum );
        M_player_type_table->setColumnAlignment( col, Qt::AlignLeft );
        ++col;
        //
        M_player_type_table->addColumn( tr( "AccMax" ),
                                        metrics.width( tr( "0.6000" ) ) + 12 );
        M_player_type_table->setColumnWidthMode( col, QListView::Maximum );
        M_player_type_table->setColumnAlignment( col, Qt::AlignLeft );
        ++col;
        //
        M_player_type_table->addColumn( tr( "DashRate" ),
                                        metrics.width( tr( "0.00600" ) ) + 12 );
        M_player_type_table->setColumnWidthMode( col, QListView::Maximum );
        M_player_type_table->setColumnAlignment( col, Qt::AlignLeft );
        ++col;
        //
        M_player_type_table->addColumn( tr( "Decay" ),
                                        metrics.width( tr( "0.400" ) ) + 12 );
        M_player_type_table->setColumnWidthMode( col, QListView::Maximum );
        M_player_type_table->setColumnAlignment( col, Qt::AlignLeft );
        ++col;
        //
        M_player_type_table->addColumn( tr( "IMoment" ),
                                        metrics.width( tr( "5.00" ) ) + 12 );
        M_player_type_table->setColumnWidthMode( col, QListView::Maximum );
        M_player_type_table->setColumnAlignment( col, Qt::AlignLeft );
        ++col;
        //
        M_player_type_table->addColumn( tr( "KickArea" ),
                                        metrics.width( tr( "1.085" ) ) + 12 );
        M_player_type_table->setColumnWidthMode( col, QListView::Maximum );
        M_player_type_table->setColumnAlignment( col, Qt::AlignLeft );
        ++col;
//         //
//         M_player_type_table->addColumn( tr( "KickMargin" ),
//                                         metrics.width( tr( "0.700" ) ) + 12 );
//         M_player_type_table->setColumnWidthMode( col, QListView::Maximum );
//         M_player_type_table->setColumnAlignment( col, Qt::AlignLeft );
//         ++col;
        //
        M_player_type_table->addColumn( tr( "KickRate" ),
                                        metrics.width( tr( "0.027" ) ) + 12 );
        M_player_type_table->setColumnWidthMode( col, QListView::Maximum );
        M_player_type_table->setColumnAlignment( col, Qt::AlignLeft );
        ++col;
        //
        M_player_type_table->addColumn( tr( "KickRand" ),
                                        metrics.width( tr( "0.00" ) ) + 12 );
        M_player_type_table->setColumnWidthMode( col, QListView::Maximum );
        M_player_type_table->setColumnAlignment( col, Qt::AlignLeft );
        ++col;
        //
        M_player_type_table->addColumn( tr( "Catch" ),
                                        metrics.width( tr( "1.0000" ) ) + 12 );
        M_player_type_table->setColumnWidthMode( col, QListView::Maximum );
        M_player_type_table->setColumnAlignment( col, Qt::AlignLeft );
        ++col;
        //
        M_player_type_table->addColumn( tr( "StamInc" ),
                                        metrics.width( tr( "45.00" ) ) + 12 );
        M_player_type_table->setColumnWidthMode( col, QListView::Maximum );
        M_player_type_table->setColumnAlignment( col, Qt::AlignLeft );
        ++col;
        //
        M_player_type_table->addColumn( tr( "Consume" ),
                                        metrics.width( tr( "55.00" ) ) + 12 );
        M_player_type_table->setColumnWidthMode( col, QListView::Maximum );
        M_player_type_table->setColumnAlignment( col, Qt::AlignLeft );
        ++col;
        //
        M_player_type_table->addColumn( tr( "ExtStam" ),
                                        metrics.width( tr( "100.00" ) ) + 12 );
        M_player_type_table->setColumnWidthMode( col, QListView::Maximum );
        M_player_type_table->setColumnAlignment( col, Qt::AlignLeft );
        ++col;
        //
        M_player_type_table->addColumn( tr( "Eff Max-Min" ),
                                        metrics.width( tr( "1.000 - 1.000" ) ) + 12 );
        M_player_type_table->setColumnWidthMode( col, QListView::Maximum );
        M_player_type_table->setColumnAlignment( col, Qt::AlignLeft );
        ++col;
        //
        M_player_type_table->addColumn( tr( "FoulProb" ),
                                        metrics.width( tr( "0.000" ) ) + 12 );
        M_player_type_table->setColumnWidthMode( col, QListView::Maximum );
        M_player_type_table->setColumnAlignment( col, Qt::AlignLeft );
        ++col;
    }

    createListViewItems();

    M_player_type_table->header()->setMovingEnabled( false );
    M_player_type_table->header()->setResizeEnabled( true );
    //M_player_type_table->header()->setStretchEnabled( true, -1 );

    layout->addWidget( M_player_type_table );
    //this->setLayout( layout ); // qt4
}

/*-------------------------------------------------------------------*/
/*!

 */
void
PlayerTypeDialog::createListViewItems()
{
    M_player_types.clear();
    M_player_type_table->clear(); // erase all data

    const int ROW_SIZE = M_main_data.viewHolder().playerTypeCont().size();

    for ( int row = 0; row < ROW_SIZE; ++row )
    {
        QListViewItem * item = new NumberListViewItem( M_player_type_table );
        M_player_types.push_back( item );

        int col = 0;
        item->setText( col++, tr( "0" ) ); // id
        //item->setText( col++, tr( "0.300" ) ); // size
        item->setText( col++, tr( "1.000 / 1.200" ) ); // speed max
        item->setText( col++, tr( "0" ) ); // accel step
        item->setText( col++, tr( "0.6000" ) ); // accel max
        item->setText( col++, tr( "0.00600" ) ); // dash power rate
        item->setText( col++, tr( "0.400" ) ); // decay
        item->setText( col++, tr( "5.00" ) ); // inertia moment
        item->setText( col++, tr( "1.085" ) ); // kickable area
        //item->setText( col++, tr( "0.700" ) ); // kickable margin
        item->setText( col++, tr( "0.02700" ) ); // kick power rate
        item->setText( col++, tr( "0.00" ) ); // kick rand
        item->setText( col++, tr( "1.000" ) ); // catch area
        item->setText( col++, tr( "45.00" ) ); // stamina inc max
        item->setText( col++, tr( "55.00" ) ); // consume
        item->setText( col++, tr( "100.00" ) ); // extra stamina
        item->setText( col++, tr( "1.000 - 1.000" ) ); // effort
        item->setText( col++, tr( "0.500" ) ); // foul detect probability

        M_player_type_table->insertItem( item );
    }
}

/*-------------------------------------------------------------------*/
/*!

 */
void
PlayerTypeDialog::showEvent( QShowEvent * )
{
    updateData();

    int total_row_height = M_player_type_table->header()->height();

    for ( std::vector< QListViewItem * >::iterator it = M_player_types.begin();
          it != M_player_types.end();
          ++it )
    {
        total_row_height += (*it)->totalHeight();
    }

    this->resize( M_player_type_table->header()->width() + 4,
                  total_row_height + 4 );

    //event->accept();
}

/*-------------------------------------------------------------------*/
/*!

 */
void
PlayerTypeDialog::updateData()
{
    if ( ! this->isVisible() )
    {
        return;
    }

    if ( M_main_data.viewHolder().playerTypeCont().size() != M_player_types.size() )
    {
        createListViewItems();
    }

    const rcsc::ServerParam & SP = rcsc::ServerParam::i();

    const int size = M_player_types.size();
    for ( int i = 0; i < size; ++i )
    {
        const std::map< int , rcsc::PlayerType >::const_iterator it
            = M_main_data.viewHolder().playerTypeCont().find( i );
        if ( it == M_main_data.viewHolder().playerTypeCont().end() )
        {
            continue;
        }

        const rcsc::PlayerType & param = it->second;

        int col = 0;
        char buf[32];

        // id
        snprintf( buf, 32, "%d", param.id() );
        M_player_types[i]->setText( col++, QString::fromAscii( buf ) );

//         // size
//         snprintf( buf, 32, "%.3f", param.playerSize() );
//         M_player_types[i]->setText( col++, QString::fromAscii( buf ) );

        // speed max
        snprintf( buf, 32, "%5.3f / %5.3f",
                  param.realSpeedMax(), param.playerSpeedMax() );
        M_player_types[i]->setText( col++, QString::fromAscii( buf ) );

        // accel step
        snprintf( buf, 32, "%d", param.cyclesToReachMaxSpeed() );
        M_player_types[i]->setText( col++, QString::fromAscii( buf ) );

        // accel max
        //snprintf( buf, 32, "%.4f",
        //          SP.maxPower() * param.dashPowerRate() * param.effortMax() );
        //M_player_types[i]->setText( col++, QString::fromAscii( buf ) );
        M_player_types[i]->setText( col++,
                                    QString::number( SP.maxPower() * param.dashPowerRate() * param.effortMax(),
                                                     'g', 5 ) );

        // dash power rate
        //snprintf( buf, 32, "%.5f", param.dashPowerRate() );
        //M_player_types[i]->setText( col++, QString::fromAscii( buf ) );
        M_player_types[i]->setText( col++, QString::number( param.dashPowerRate(), 'g', 4 ) );

        // decay
        //snprintf( buf, 32, "%.3f", param.playerDecay() );
        //M_player_types[i]->setText( col++, QString::fromAscii( buf ) );
        M_player_types[i]->setText( col++, QString::number( param.playerDecay(), 'g', 5 ) );

        // inertia moment
        //snprintf( buf, 32, "%.2f", param.inertiaMoment() );
        //M_player_types[i]->setText( col++, QString::fromAscii( buf ) );
        M_player_types[i]->setText( col++, QString::number( param.inertiaMoment(), 'g', 5 ) );

        // kickable area
        //snprintf( buf, 32, "%.3f", param.playerSize() + param.kickableMargin() + SP.ballSize() );
        //M_player_types[i]->setText( col++, QString::fromAscii( buf ) );
        M_player_types[i]->setText( col++,
                                    QString::number( param.playerSize() + param.kickableMargin() + SP.ballSize(),
                                                     'g', 4 ) );

//         // kickable margin
//         snprintf( buf, 32, "%.3f", param.kickableMargin() );
//         M_player_types[i]->setText( col++, QString::fromAscii( buf ) );

        // kick power rate
        //snprintf( buf, 32, "%.5f", param.kickPowerRate() );
        //M_player_types[i]->setText( col++, QString::fromAscii( buf ) );
        M_player_types[i]->setText( col++, QString::number( param.kickPowerRate(), 'g', 4 ) );

        // kick rand
        //snprintf( buf, 32, "%.2f", param.kickRand() );
        //M_player_types[i]->setText( col++, QString::fromAscii( buf ) );
        M_player_types[i]->setText( col++, QString::number( param.kickRand(), 'g', 3 ) );

        // stretched catch area
        double r = std::sqrt( std::pow( SP.catchAreaWidth() * 0.5, 2 )
                              + std::pow( SP.catchAreaLength() * param.catchAreaLengthStretch(), 2 ) );
        //snprintf( buf, 32, "%.4f", r );
        //M_player_types[i]->setText( col++, QString::fromAscii( buf ) );
        M_player_types[i]->setText( col++, QString::number( r, 'g', 5 ) );

        // stamina inc max
        //snprintf( buf, 32, "%.2f", param.staminaIncMax() );
        //M_player_types[i]->setText( col++, QString::fromAscii( buf ) );
        M_player_types[i]->setText( col++, QString::number( param.staminaIncMax(), 'g', 4 ) );

        // consume
        //snprintf( buf, 32, "%.2f", param.getOneStepStaminaComsumption() );
        //M_player_types[i]->setText( col++, QString::fromAscii( buf ) );
        M_player_types[i]->setText( col++, QString::number( param.getOneStepStaminaComsumption(), 'g', 4 ) );

        // extra stamina
        //snprintf( buf, 32, "%.2f", param.extraStamina() );
        //M_player_types[i]->setText( col++, QString::fromAscii( buf ) );
        M_player_types[i]->setText( col++, QString::number( param.extraStamina(), 'g', 4 ) );

        // effort
        snprintf( buf, 32, "%.3f - %.3f", param.effortMax(), param.effortMin() );
        M_player_types[i]->setText( col++, QString::fromAscii( buf ) );

        // foul detect probability
        //snprintf( buf, 32, "%.2f", param.foulDetectProbability() );
        //M_player_types[i]->setText( col++, QString::fromAscii( buf ) );
        M_player_types[i]->setText( col++, QString::number( param.foulDetectProbability(), 'g', 4 ) );
    }

    M_player_type_table->setSorting( 0 ); // sorted by column 0
    M_player_type_table->sort();

}
