// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hiroki SHIMORA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "default_field_evaluator.h"
#include "fixed_pass_course_table.h"
#include "world_model_ext.h"
#include <rcsc/common/server_param.h>

#include <cmath>
#include <cfloat>

DefaultFieldEvaluator::DefaultFieldEvaluator()
{
}

DefaultFieldEvaluator::~DefaultFieldEvaluator()
{
}

double
DefaultFieldEvaluator::operator()
                   ( const rcsc::PredictState & state,
                     const rcsc::WorldModel & wm,
                     const std::vector< rcsc::ActionStatePair > & path ) const
{
    const rcsc::AbstractPlayerObject * holder = state.ballHolder();
    const int holder_unum = holder->unum();

    const FixedPassCourseTable & evaluate_table = FixedPassCourseTable::instance( wm );
    const std::vector< FixedPassCourseTable::ConnectionTable > &
        table = evaluate_table.get_table( wm );


    //
    // if holder is invalid, return bad evaluation
    //
    if ( ! holder )
    {
        return - DBL_MAX / 2.0;
    }


    //
    // out of pitch
    //
    if ( state.ballPos().absX()
         > rcsc::ServerParam::i().pitchHalfLength()
         || state.ballPos().absY()
            > rcsc::ServerParam::i().pitchHalfWidth() )
    {
        return - DBL_MAX / 2.0;
    }


    //
    // set basic point
    //
    double point = state.ballPos().x;


    //
    // add bonus for goal, push
    //
    if ( table[holder_unum].goal == true )
    {
        point += 1.0e+6;

        if ( holder_unum == state.self().unum() )
        {
            point += 5.0e+5;
        }

#if 0
        // XXX
        Angle shoot_width = Bhv_Shoot::free_angle_with_ball_coordinate
                            ( state,
                              Act_Shoot::DEFAULT_VALID_OPPONENT_ACCURACY,
                              holder->pos() );

        point += std::max( shoot_width.degree(), 20.0 ) * 10.0;
#endif
    }
    else if ( table[holder_unum].push == true )
    {
        point += 1.0e+5 + ( rcsc::ServerParam::i().pitchHalfLength()
                            - holder->pos().absX() ) * 2.0;

#if 0
        if ( holder_unum == state.self().unum() )
        {
            point += 1.0e+5;
        }
#endif
    }

    if ( state.ballPos().x > state.offsideLineX() )
    {
        point += 5.0e+5;
    }



    //
    // add distance bonus when near opponent goal
    //
    double their_goal_dist = ( holder->pos()
                               - rcsc::ServerParam::i().theirTeamGoalPos() ).r();
    point -= their_goal_dist;

    if ( their_goal_dist <= 30.0 )
    {
        point += (30.0 - their_goal_dist) * 10.0;
    }


    //
    // add distance penalty when near our goal
    //
    double our_goal_dist = ( holder->pos()
                             - rcsc::ServerParam::i().ourTeamGoalPos() ).r();
    point += our_goal_dist;

    if ( our_goal_dist <= 25.0 )
    {
        point -= ( 25.0 - our_goal_dist ) * 5.0;
    }



#if 0
    // XXX: bug, but works well...

    //
    // add bonus near offside line
    //
    if ( state.ballPos().x > state.offsideLineX() - 5.0 )
    {
# if 0
        point += ( state.ballPos().x
                   - (state.defenseLineX() -5.0) ) * 3.0;
# else
        point += ( state.ballPos().x
                   - (state.defenseLineX() -5.0) ) * 10.0;
# endif
    }
#else
    //
    // add bonus near offside line
    //
    if ( state.ballPos().x > state.offsideLineX() - 5.0 )
    {
        point += ( state.ballPos().x
                   - (state.offsideLineX() -5.0) ) * 10.0;
    }
#endif

    //
    // add penalty near defense line
    //
    if ( state.ballPos().x < state.defenseLineX() + 5.0 )
    {
        point += ( state.ballPos().x
                   - (state.defenseLineX() + 5.0) ) * 10.0;
    }



    //
    // add absolute x pos bonus
    //
    if ( holder->pos().x >= 20.0 )
    {
        point += ( 20.0 - holder->pos().x ) * 5.0;
    }



    //
    // add free radius bonus
    //
    {
#if 0
        // XXX: should calculate from state
        const double r = table[holder_unum].free_radius;
#else
        const double r = rcsc_ext::getDistOpponentNearestToPoint( wm, holder->pos() );
#endif

        double factor = 10.0;

        if ( holder_unum == state.self().unum() )
        {
            factor = 1000.0;
        }

        if ( r < 10.0 )
        {
            point -= factor * (10 - r);
        }
    }


    //
    // add pass count bonus
    //
    int pass_count = 0;
    for ( int i = 1; i <= rcsc::ServerParam::i().maxPlayer(); ++i )
    {
        if ( table[holder_unum].player[i]
             && i != holder->unum() )
        {
            ++pass_count;
        }
    }
#if 0
   point += std::min( pass_count, 3 ) * 3.0;
#else
   point += std::min( pass_count, 3 ) * 20.0;
#endif


    //
    // penalty by path length
    //
    point -= path.size() * 1.0;


#if 0
    //
    // bonus if single kick pass
    //
    if ( ! path.empty() )
    {
        const rcsc::CooperativeAction & act = path[0].action;

        if ( act.type() == rcsc::CooperativeAction::ActionType::Pass
             && rcsc_ext::WorldModel_canKickByOneStep
                ( wm,
                  act.getBallSpeed(),
                  ( act.getTargetPoint() - state.ballPos() ).th() ) )
        {
            point += 10.0;
        }
    }
#endif

    return point;
}
