// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hiroki SHIMORA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "actgen_omnidir_dribble.h"

#include "world_model_ext.h"
#include <rcsc/common/logger.h>
#include <rcsc/geom/sector_2d.h>
#include <rcsc/geom/angle_deg.h>

#if 1
static const double DRIBBLE_LENGTH = 5.0;
#elif 0
static const double DRIBBLE_LENGTH = 3.0;
#else
static const double DRIBBLE_LENGTH = 10.0;
#endif
static const double DRIBBLE_FREE_LENGTH = 3.0;
static const long VALID_PLAYER_ACCURACY = 20;
static const long VALID_OPPONENT_ACCURACY = VALID_PLAYER_ACCURACY;

static
bool
s_dribble_check( const rcsc::WorldModel & wm, // fixed opponents
                 const rcsc::AbstractPlayerObject * pl,
                 const rcsc::AngleDeg & dir );

static
unsigned long
dribble_spend_time( double dribble_length );

void
ActGen_OmnidirDribble::addCandidates( std::vector< rcsc::ActionStatePair > * result,
                                      const rcsc::PredictState & state,
                                      const rcsc::WorldModel & current_wm,
                                      const std::vector< rcsc::ActionStatePair > & path ) const
{
#if 0
    int N_DIVISION = 4;
#else
    int N_DIVISION = 8;
#endif
    bool half_shift = true;
    bool add_forward = true;


    //
    // check game mode
    //
    if ( (state.gameMode().type() == rcsc::GameMode::KickOff_
          && state.gameMode().side() == current_wm.ourSide())
         || (state.gameMode().type() == rcsc::GameMode::FreeKick_
             && state.gameMode().side() == current_wm.ourSide())
         || (state.gameMode().type() == rcsc::GameMode::KickIn_
             && state.gameMode().side() == current_wm.ourSide()))
    {
        return;
    }


    //
    // check valid ball holder
    //
    const rcsc::AbstractPlayerObject * holder = state.ballHolder();
    const rcsc::Vector2D holder_pos = holder->pos();

    rcsc::dlog.addText( rcsc::Logger::ACTION,
                        "holder_pos [%f,%f]",
                        holder->pos().x, holder->pos().y );

    if ( ! holder
         || holder->posCount() > VALID_PLAYER_ACCURACY
         || holder->isGhost() )
    {
        return;
    }

    if ( holder->pos().x > state.offsideLineX() )
    {
#if DEBUG_PRINT
        dlog.addText( rcsc::Logger::ACTION,
                      __FILE__": checking dribble player %d: offside position",
                      holder->unum() );
#endif
        return;
    }

#if 0
    if ( holder->pos().x > rcsc::ServerParam::i().pitchLength() - 20.0 )
    {
        N_DIVISION *= 2;
        half_shift = false;
    }
#endif

#if 0
    if ( holder->isSelf() && path.size() == 0 )
    {
        N_DIVISION *= 2;
    }
#endif

#if 0
    if ( path.size() >= 2 && ! holder->isSelf() )
    {
        return candidates;
    }
#else
    static_cast<void>(path);
#endif



    //
    // add dribble candidate
    //
    std::vector< rcsc::AngleDeg > dir_candidates;
    dir_candidates.reserve( N_DIVISION );
    for ( int i = 0; i < N_DIVISION; ++i )
    {
        dir_candidates.push_back( rcsc::AngleDeg( (i + (half_shift? 0.5 : 0.0))
                                                  * (360.0 / N_DIVISION) ) );
    }

    if ( add_forward && half_shift )
    {
        dir_candidates.push_back( rcsc::AngleDeg( 0.0 ) );
    }

    for ( size_t i = 0; i < dir_candidates.size(); ++i )
    {
        const rcsc::AngleDeg & dir = dir_candidates[i];

        rcsc::Vector2D dribble_target
            = holder_pos + rcsc::Vector2D::polar2vector( DRIBBLE_LENGTH, dir );

        if ( dribble_target.absX()
             >= rcsc::ServerParam::i().pitchLength() - 3.0
             || dribble_target.absY()
             >= rcsc::ServerParam::i().pitchWidth() - 3.0 )
        {
            rcsc::dlog.addText( rcsc::Logger::ACTION,
                                "holder = %d, dir = %.2f, "
                                "dribble target is out of field",
                                holder->unum(), dir.degree() );
            continue;
        }

        if ( dribble_target.x
             <= rcsc::ServerParam::i().ourPenaltyAreaLineX() + 5.0
             && dribble_target.absY()
             <= rcsc::ServerParam::i().penaltyAreaHalfWidth() )
        {
            rcsc::dlog.addText( rcsc::Logger::ACTION,
                                "holder = %d, dir = %.2f, "
                                "penalty area",
                                holder->unum(), dir.degree() );
            continue;
        }

        if ( s_dribble_check( current_wm, holder, dir ) )
        {
            rcsc::dlog.addText( rcsc::Logger::ACTION,
                                "holder = %d, dir = %.2f, can dribble",
                                holder->unum(), dir.degree() );

            rcsc::PredictState new_state( state,
                                          dribble_spend_time( DRIBBLE_LENGTH ),
                                          holder->unum(), dribble_target );

            result->push_back( rcsc::ActionStatePair
                               ( rcsc::CooperativeAction
                                 ( rcsc::CooperativeAction::ActionType::Dribble,
                                   dribble_target,
                                   holder->unum() ),
                                 new_state ) );
        }
        else
        {
            rcsc::dlog.addText( rcsc::Logger::ACTION,
                                "holder = %d, dir = %.2f, cannot dribble",
                                holder->unum(), dir.degree() );
        }
    }
}


namespace rcsc {

// XXX: move to rcsc/player/player_predicate.h
// XXX: change to use abstract class Region2D

/*!
  \class ContainsPlayerPredicate
  \brief check if target player is in region
*/
template<typename T>
class ContainsPlayerPredicate
    : public rcsc::PlayerPredicate
{
private:
    //! geomotry to check
    T M_geom;

public:
    /*!
      \brief construct with the geometry object
      \param geometry object for checking
    */
    ContainsPlayerPredicate( const T & geom )
        : M_geom( geom )
      {
      }

    /*!
      \brief predicate function
      \param p const reference to the target player object
      \return true if target player is in the region
    */
    bool operator()( const rcsc::AbstractPlayerObject & p ) const
      {
          return M_geom.contains( p.pos() );
      }
};

}


static
bool
s_dribble_check( const rcsc::WorldModel & wm, // assume opponents doesn't move
                 const rcsc::AbstractPlayerObject * pl,
                 const rcsc::AngleDeg & dir )
{
#if 0
    const rcsc::Sector2D sector( pl->pos(),
                                 0.0, DRIBBLE_LENGTH,
                                 dir - 30.0,
                                 dir + 30.0 );
#elif 0
    const double back_dist = 0.5;
    const rcsc::Sector2D sector( pl->pos()
                                 - rcsc::Vector2D::polar2vector
                                   ( back_dist, dir ),
                                 0.0, DRIBBLE_LENGTH * 1.5 + back_dist,
                                 dir - 30.0,
                                 dir + 30.0 );
#elif 0
    const double back_dist = 3.0;
    const rcsc::Sector2D sector( pl->pos()
                                 - rcsc::Vector2D::polar2vector
                                   ( back_dist, dir ),
                                 0.0, DRIBBLE_LENGTH * 1.5 + back_dist,
                                 dir - 45.0,
                                 dir + 45.0 );
#elif 0
    const double back_dist = 5.0;
    const rcsc::Sector2D sector( pl->pos()
                                 - rcsc::Vector2D::polar2vector
                                   ( back_dist, dir ),
                                 0.0, DRIBBLE_LENGTH * 2 + back_dist,
                                 dir - 45.0,
                                 dir + 45.0 );
#else
# if 0
    const double back_dist = 3.0;
# else
    const double back_dist = 2.0;
# endif
    const rcsc::Sector2D sector( pl->pos()
                                 - rcsc::Vector2D::polar2vector
                                   ( back_dist, dir ),
                                 0.0, DRIBBLE_LENGTH * 2 + back_dist,
                                 dir - 40.0,
                                 dir + 40.0 );
#endif

#if 0
    rcsc::AbstractPlayerCont opp_set;
    opp_set = wm.getPlayerCont
                 ( new rcsc::AndPlayerPredicate
                   ( new rcsc::OpponentOrUnknownPlayerPredicate( wm ),
                     new rcsc::CoordinateAccuratePlayerPredicate
                     ( VALID_PLAYER_ACCURACY ),
                     new rcsc::ContainsPlayerPredicate<rcsc::Sector2D>
                     ( sector ) ) );

    return opp_set.empty();
#elif 1
    rcsc::AbstractPlayerCont opp_set;
    opp_set = wm.getPlayerCont
                 ( new rcsc::AndPlayerPredicate
                   ( new rcsc::OpponentOrUnknownPlayerPredicate( wm ),
                     new rcsc::CoordinateAccuratePlayerPredicate
                     ( VALID_PLAYER_ACCURACY ),
                     new rcsc::OrPlayerPredicate
                     ( new rcsc::ContainsPlayerPredicate<rcsc::Sector2D>
                       ( sector ),
                       new rcsc::PointNearPlayerPredicate
                       ( pl->pos(), DRIBBLE_FREE_LENGTH ) ) ) );

    return opp_set.empty();
#else
    // XXX: will be switch to this implementation
    return wm.playerExist
              ( new rcsc::AndPlayerPredicate
                ( new rcsc::OpponentOrUnknownPlayerPredicate( wm ),
                  new rcsc::CoordinateAccuratePlayerPredicate
                  ( VALID_PLAYER_ACCURACY ),
                  new rcsc::ContainsPlayerPredicate<rcsc::Sector2D>
                  ( sector ) ) );
#endif
}

static
unsigned long
dribble_spend_time( double dribble_length )
{
    return static_cast< unsigned long >( dribble_length * 2.0 );
}

