// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hiroki SHIMORA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "actgen_lead_pass.h"
#include "simple_pass_checker.h"
#include "world_model_ext.h"
#include <rcsc/common/logger.h>
#include <rcsc/math_util.h>
#include <utility>

ActGen_LeadPass::ActGen_LeadPass()
{
}

ActGen_LeadPass::~ActGen_LeadPass()
{
}


// XXX: should unify with bhv_basic_kick.cpp
static
double
s_get_ball_speed_for_pass( const double & distance );

void
ActGen_LeadPass::addCandidates( std::vector< rcsc::ActionStatePair > * result,
                                const rcsc::PredictState & state,
                                const rcsc::WorldModel &,
                                const std::vector< rcsc::ActionStatePair > & ) const
{
    static const int VALID_PLAYER_THRESHOLD = 8;

    const rcsc::AbstractPlayerObject * holder = state.ballHolder();

    //
    // add pass candidates
    //
    std::vector< double > r_candidates;
#if 0
    r_candidates.push_back( 5.0 );
#endif
    r_candidates.push_back( 10.0 );


    int N_DIVISION = 8;
    std::vector< std::pair< double, rcsc::AngleDeg > > check_candidates;

    for ( size_t r = 0; r < r_candidates.size(); ++r )
    {
        for ( int i = 0; i < N_DIVISION; ++i )
        {
            check_candidates.push_back( std::make_pair( r_candidates[r],
                                                        rcsc::AngleDeg( 360.0 / N_DIVISION ) ) );
        }
    }

    const rcsc::SimplePassChecker pass_check;

    const rcsc::PredictState::PlayerCont::const_iterator end = state.allTeammates().end();
    for ( rcsc::PredictState::PlayerCont::const_iterator pl = state.allTeammates().begin();
          pl != end;
          ++pl )
    {
        if ( ! (*pl).valid()
             || (*pl).posCount() > VALID_PLAYER_THRESHOLD
             || (*pl).isGhost()
#if 0
             || (*pl).unum() == state.getBallHolderUnum()
#endif
             || (*pl).unum() == -1 )
        {
            continue;
        }

        for ( size_t i = 0; i < check_candidates.size(); ++i )
        {
            rcsc::Vector2D receive_point
                ( (*pl).pos()
                   + rcsc::Vector2D::polar2vector
                     ( check_candidates[i].first,
                       check_candidates[i].second ) );

            rcsc::Vector2D teammate_pos = (*pl).pos();

            if ( (*pl).velCount() == 0 )
            {
                teammate_pos += (*pl).vel() * 2.0;
            }


            const double ball_dist = ( state.ballPos() - receive_point ).r();
            const double ball_first_speed = s_get_ball_speed_for_pass( ball_dist );
            const double receiver_dist = ( teammate_pos - receive_point ).r();


            long ball_step = rcsc::calc_length_geom_series
                             ( ball_first_speed,
                               ball_dist,
                               rcsc::ServerParam::i().ballDecay() );

            double receiver_step = (*pl).playerTypePtr()->cyclesToReachDistance( receiver_dist );

            if ( receiver_step + 3 > ball_step )
            {
                continue;
            }

            if ( ! pass_check( state, holder, &(*pl), receive_point ) )
            {
                continue;
            }

            result->push_back( rcsc::ActionStatePair
                               ( rcsc::CooperativeAction
                                 ( rcsc::CooperativeAction::ActionType::Pass,
                                   receive_point,
                                   (*pl).unum(),
                                   ball_first_speed,
                                   "lead" ),
                                 rcsc::PredictState
                                 ( state, ball_step,
                                   (*pl).unum(), receive_point ) ) );
        }
    }
}


static
double
s_get_ball_speed_for_pass( const double & distance )
{
    if ( distance >= 20.0 )
    {
        return 3.0;
    }
    else if ( distance >= 8.0 )
    {
        return 2.5;
    }
    else if ( distance >= 5.0 )
    {
        return 1.8;
    }
    else
    {
        return 1.5;
    }
}
