// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hiroki SHIMORA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "actgen_direct_pass.h"
#include "world_model_ext.h"
#include "simple_pass_checker.h"
#include <rcsc/math_util.h>
#include <rcsc/common/logger.h>

ActGen_DirectPass::ActGen_DirectPass()
{
}

ActGen_DirectPass::~ActGen_DirectPass()
{
}


// XXX: should unify with bhv_basic_kick.cpp
static
double
s_get_ball_speed_for_pass( const double & distance );

void
ActGen_DirectPass::addCandidates( std::vector< rcsc::ActionStatePair > * result,
                                  const rcsc::PredictState & state,
                                  const rcsc::WorldModel &,
                                  const std::vector< rcsc::ActionStatePair > & ) const
{
    static const int VALID_PLAYER_THRESHOLD = 8;

    const rcsc::AbstractPlayerObject * holder = state.ballHolder();
    const rcsc::SimplePassChecker pass_check;

    //
    // add pass candidates
    //
    const rcsc::PredictState::PlayerCont::const_iterator end = state.allTeammates().end();
    for ( rcsc::PredictState::PlayerCont::const_iterator it = state.allTeammates().begin();
          it != end;
          ++it )
    {
        if ( ! (*it).valid()
             || (*it).posCount() > VALID_PLAYER_THRESHOLD
             || (*it).isGhost()
             || (*it).unum() == state.ballHolderUnum()
             || (*it).unum() == -1 )
        {
            continue;
        }

        if ( ! pass_check( state, holder, &(*it), (*it).pos() ) )
        {
            continue;
        }

        const double dist = ( (*it).pos() - holder -> pos() ).r();

        const double ball_speed = s_get_ball_speed_for_pass
                                  ( ( (*it).pos() - holder -> pos() ).r() );

        const unsigned long spend_time = rcsc::calc_length_geom_series
                                         ( ball_speed,
                                           dist,
                                           rcsc::ServerParam::i().ballDecay() );

        result->push_back( rcsc::ActionStatePair
                           ( rcsc::CooperativeAction
                             ( rcsc::CooperativeAction::ActionType::Pass,
                               (*it).pos(),
                               (*it).unum(),
                               s_get_ball_speed_for_pass( dist ),
                               "direct" ),
                             rcsc::PredictState( state,
                                                 spend_time,
                                                 (*it).unum(), (*it).pos() ) ) );
    }
}


static
double
s_get_ball_speed_for_pass( const double & distance )
{
    if ( distance >= 20.0 )
    {
        return 3.0;
    }
    else if ( distance >= 8.0 )
    {
        return 2.5;
    }
    else if ( distance >= 5.0 )
    {
        return 1.8;
    }
    else
    {
        return 1.5;
    }
}
