// -*-c++-*-

/*!
  \file ray_2d.cpp
  \brief 2D ray line class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa Akiyama

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "ray_2d.h"

namespace rcsc {

/*-------------------------------------------------------------------*/
/*!

 */
bool
Ray2D::intersection( const Line2D & other,
                     Vector2D * sol ) const
{
    Vector2D tmp_sol( Vector2D::INVALID );
    Line2D my_line = this->line();

    if ( ! my_line.intersection( other, &tmp_sol ) )
    {
        return false;
    }

    if ( ! inRightDir( tmp_sol ) )
    {
        return false;
    }

    if ( sol )
    {
        *sol = tmp_sol;
    }

    return true;
}

}
