// -*-c++-*-

/*!
  \file intention_dribble.h
  \brief queued dribble behavior
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef RCSC_ACTION_INTENTION_DRIBBLE_H
#define RCSC_ACTION_INTENTION_DRIBBLE_H

#include <rcsc/game_time.h>
#include <rcsc/geom/vector_2d.h>

#include <rcsc/player/soccer_intention.h>

namespace rcsc {

/*!
  \class IntentionDribble
  \brief queued dribble behavior
*/
class IntentionDribble
    : public SoccerIntention {
private:
    const Vector2D M_target_point; // global coordinate
    const double M_dist_thr;

    int M_turn_step;
    int M_dash_step;

    const double M_dash_power_abs;
    const bool M_back_dash_mode;

    GameTime M_last_execute_time;

public:
    IntentionDribble( const Vector2D & target_point,
                      const double & dist_thr,
                      const int turn_step,
                      const int dash_step,
                      const double & dash_power_abs,
                      const bool back_dash,
                      const GameTime & start_time )
        : M_target_point( target_point )
        , M_dist_thr( dist_thr )
        , M_turn_step( turn_step )
        , M_dash_step( dash_step )
        , M_dash_power_abs( dash_power_abs )
        , M_back_dash_mode( back_dash )
        , M_last_execute_time( start_time )
      { }

    bool finished( const PlayerAgent* agent );

    /*!
      \brief execute action
      \param agent pointer to the agent itself
      \return true if action is performed
    */
    bool execute( PlayerAgent* agent );

private:

    void clear()
      {
          M_turn_step = M_dash_step = 0;
      }

    bool checkOpponent( const WorldModel & world );

    bool doTurn( PlayerAgent * agent );
    bool doDash( PlayerAgent * agent );

};

}

#endif
