/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.util.xml.parse;

import java.io.IOException;
import org.util.xml.element.TextElement;

/**
 *   
 * <div>
 * &lt;? ... ?&gt;<br/>
 * e.x.<br/>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;<br/>
 * </div>
 * @author masaru
 */
public class CommentInnerTagElementParser extends ParseElement {
    
    private int cc,ccc;
    private String return_value_;
    private TextElement text_element_;
    
    public CommentInnerTagElementParser() {
        
    }

    @Override
    public boolean match(char c) {
        return c=='!';
    }

    @Override
        public int parse(int c, ElementParser parser) throws XMLParseException, IOException {
        int type = -1;
        StringBuffer sb = new StringBuffer();
        if(c!='!') throw new XMLParseException("parse error: cannot read comment tag");
        c=parser.get();
        cc=-1;
        ccc=-1;
        for(int state = 0;;) {
            
            if(state == 0) {
                sb.append((char)c);
                if(c == '-') state = 3;
                else if(c == '[') state = 2;
                else state = 1;
            } else if(state == 1) {
		if(c=='[') {
		    state = 6;
		    sb.append((char)c);
                } else if(c=='>') {
                    type = 0;
                    break;
                } else {
                    sb.append((char)c);
                }
            } else if(state == 2) {
                sb.append((char)c);
                String cdata = "CDATA[";
                boolean match = true;
                for(int i=0; i<cdata.length()&&match;i++) {
                    if(i!=0)
                        c = parser.get();
                    sb.append((char)c);
                    match = (cdata.charAt(i)==c);
                }
                if(match) {
                    sb = new StringBuffer();
                    state = 5;
                } else state = 1;
            } else if(state == 3) {
                if(c=='-') {
                    sb = new StringBuffer();
                    state = 4;
                } else {
                    sb.append((char)c);
                    state = 1;
                }
            } else if(state == 4) {
                if(ccc=='-' && cc=='-' && c=='>') {
                    type = 1;
                    break;
                } else if(ccc != -1) sb.append((char)ccc);
                ccc = cc;
                cc = c;
            } else if(state == 5) {
                if(ccc==']' && cc==']' && c=='>') {
                    type = 2;
                    break;
                } else if(ccc != -1) sb.append((char)ccc);
                ccc = cc;
                cc = c;
            } else if(state == 6) {
		if(c==']') {
		    sb.append((char)c);
		    state = 1;
		} else
		    sb.append((char)c);
	    }
            c=parser.getChar();
        }
        return_value_ = sb.toString();
        text_element_ = new TextElement(return_value_);
        if(type==0) text_element_.setTag(true);
        else if(type==1) text_element_.setCommenTag(true);
        else if(type==2) text_element_.setCDATATag(true);
        
        return parser.get();
    }

    public TextElement getResult() {
        return text_element_;
    }
    
    @Override
    public String getReturnValue() {
        return return_value_;
    }
}
