/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.util.xml.element;

import java.util.ArrayList;

/**
 *
 * @author masaru
 */
public class Attributes {
    
    ArrayList<Attribute> attribute_list_;
    
    public Attributes() {
        attribute_list_ = new ArrayList<Attribute>();
    }
    public Attributes(Attribute... list) {
        this();
        for(int i=0;i<list.length;i++)
            add(list[i]);
    }
    /**
     * lowest method of add
     * @param attribute
     */
    public void add(Attribute attribute) {
        attribute_list_.add(attribute);
    }
    public void add(String name, String value) {
        attribute_list_.add(new Attribute(name, value));
    }
    public void set(Attribute new_attribute) {
        Attribute attribute = get(new_attribute.getName());
        if(attribute==null) add(new_attribute);
        else attribute.setValue(new_attribute.getValue());
    }
    public void set(String name, String value) {
        set(new Attribute(name, value));
    }
    
    public int size() {
        return attribute_list_.size();
    }
    public Attribute get(int index) {
        return attribute_list_.get(index);
    }
    public Attribute get(String name) {
        for(int i=0;i<attribute_list_.size();i++) {
            Attribute attribute = attribute_list_.get(i);
            if(attribute.getName().equals(name))
                return attribute;
        }
        return null;
    }
    public String getValue(String name, String return_if_return_value_is_null) {
        for(int i=0;i<attribute_list_.size();i++)
            if(attribute_list_.get(i).getName().toLowerCase().equals(name.toLowerCase()))
                return attribute_list_.get(i).getValue();
        return return_if_return_value_is_null;
    }
    public String getValue(String attribute_name) {
        return getValue(attribute_name, null);
    }
    
    public String toString() {
        if(attribute_list_.size()==0) return "";
        StringBuffer sb = new StringBuffer(attribute_list_.get(0).toString());
        for(int i=1;i<attribute_list_.size();i++) {
            sb.append(" ").append(attribute_list_.get(i));
        }
        return sb.toString();
    }
    
    public static final Attributes EmptySet = new Attributes(){
        
        public void add(Attribute attribute){}
        public Attribute get(int index) {
            return null;
        }
        public String getValue(String name) {
            return null;
        }
    };
}
