/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.util.xml;

import org.util.xml.parse.ElementParser;
import java.awt.BorderLayout;
import java.awt.Desktop;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.util.xml.element.Element;
import org.util.xml.element.TagElement;
import org.util.xml.parse.policy.HTMLParserPolicy;
import org.util.xml.parse.policy.XMLParserPolicy;

/**
 *
 * @author masaru
 */
public class Main {
    
    JTextArea textarea1 = new JTextArea();
    JTextArea textarea2 = new JTextArea();
    //JTextArea textarea3 = new JTextArea();
    JPanel buttonpane = new JPanel();
    
    
    public static void main(String[] args) throws Exception {
        new Main();
    }

    public Main() {
        
        JPanel panel = new JPanel(new GridLayout(1,3));
        panel.add(new JScrollPane(textarea1));
        panel.add(new JScrollPane(textarea2));
        //panel.add(new JScrollPane(textarea3));
        panel.add(buttonpane);
        
        JTextField textfield = new JTextField("http://www.google.com/");
        textfield.addActionListener(new ActionListener(){
            public void actionPerformed(final ActionEvent e) {
                new Thread(new Runnable(){public void run(){
                    openURL(((JTextField)e.getSource()).getText());
                }}).start();
            }
        });
        
        JPanel contentpane = new JPanel(new BorderLayout());
        contentpane.add(textfield,BorderLayout.NORTH);
        contentpane.add(panel,BorderLayout.CENTER);
        contentpane.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
        
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setContentPane(contentpane);
        frame.setSize(200,200);
        frame.setLocation(100,100);
        frame.setVisible(true);

    }
    public void openURL(final String urltext) {
        
        try{
            String encoding = "JISAutoDetect";
            URL url = new URL(urltext);
            textarea1.setText("");

            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream(), encoding));
            String tmp;
            while((tmp=br.readLine()) != null)
                textarea1.append(tmp+"\n");
            br.close();

            final JPanel subbuttonpane = new JPanel();
            subbuttonpane.setLayout(new BoxLayout(subbuttonpane, BoxLayout.Y_AXIS));

            
            //textarea3.setText("");
            buttonpane.removeAll();
            buttonpane.setLayout(new BorderLayout());
            JScrollPane sp = new JScrollPane(subbuttonpane);
            sp.getVerticalScrollBar().setUnitIncrement(30);
            buttonpane.add(sp, BorderLayout.CENTER);

            /// XMLParser parser = new XMLParser(new InputStreamReader(new FileInputStream(file)));
            InputStream is2 = url.openStream();
            ElementParser parser = new ElementParser(is2);
            parser.setPolicy(new HTMLParserPolicy(){
/*
                public boolean allowTagKey(String tagkey) {
                    
                    // if(tagkey.equals("br")) return false;
                    // return true;
                    
                    // return (tagkey==null || tagkey.equals("html") || tagkey.equals("body") || tagkey.equals("b") || tagkey.equals("center") || tagkey.equals("table") || tagkey.equals("td") || tagkey.equals("tr") || tagkey.equals("a"));
                    return true;
                }
                
                public boolean allowAttributes(Attributes attributes) {
                    return true;
                }
*/
                @Override
                public Element allowElement(Element element) {
                    super.allowElement(element);
                    
                    if(element.isTagElement()) {
                        String text = ((TagElement)element).getKey();
                        if(text.toLowerCase().equals("a")) {
                            String surl = ((TagElement)element).getAttributeValue("href","");
                            String comment = element.toString();
                            if(!surl.startsWith("http:"))
                                surl = urltext + "/../"+surl;
                            final String url = surl;
                            if(url.startsWith("http:")) {
                                JButton button = new JButton(new AbstractAction(url){
                                    public void actionPerformed(ActionEvent arg0) {
                                        try{
                                            Desktop.getDesktop().browse(new URI(url));
                                        }catch(Exception e){
                                            JOptionPane.showMessageDialog(null, "Error:"+e.getMessage()+"\n"+url);
                                        }
                                    }
                                });
                                button.setToolTipText("<html><body>"+comment+"</body></html>");
                                subbuttonpane.add(button);
                                subbuttonpane.doLayout();
                                buttonpane.doLayout();
                                buttonpane.setVisible(true);
                            }
                                
//                                textarea3.append(url);
                        }
                    }
                    
                    return element;
                }
                
            });

//            parser.setPolicy(new XMLParserPolicy());
            System.out.println("start parsing");

            parser.parse();
            is2.close();

            Element[] element = parser.getResult();

            Element.setTabText("|");

            System.out.println("end parsing");
            textarea2.setText("");
            for(int i=0;i<element.length;i++)
                textarea2.append(element[i].toString());
            System.out.println("finished");
            
        } catch(Exception exc) {
            exc.printStackTrace();
            JOptionPane.showMessageDialog(null, exc);
        }
    }

}
