package org.util.html.objects;


import java.util.*;
import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;


import org.util.html.event.*;

public class HTMLDocument {

    private URL url_;
    private ArrayList<HTMLListener> listener_list_ = new ArrayList<HTMLListener>();
    private ArrayList<HTMLObject> object_list_ = new ArrayList<HTMLObject>();

    public HTMLDocument() {
    }

    public void clear() {
	url_ = null;
	object_list_.clear();
	for(HTMLListener listener : listener_list_)
	    listener.cleared(this);
    }

    public void add(HTMLObject obj) {
	object_list_.add(obj);
	for(HTMLListener listener : listener_list_)
	    listener.added(this, obj);
    }

    public void changed(HTMLObject obj){
	for(HTMLListener listener : listener_list_)
	    listener.changed(this, obj);
    }

    public HTMLObject[] getObjectList() {
	return object_list_.toArray(new HTMLObject[0]);
    }

    public void setDocumentBase(URL url) {
	url_ = url;
	for(HTMLListener listener : listener_list_)
	    listener.changed(this, null);
    }

    public URL getDocumentBase() {
	return url_;
    }

    public void addHTMLListener(HTMLListener listener) {
	listener_list_.add(listener);
    }
    public void removeHTMLListener(HTMLListener listener) {
	listener_list_.remove(listener);
    }
}
