/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.registry;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import rescuecore2.messages.Message;
import rescuecore2.registry.MessageFactory;

public class FilterMessageFactory
implements MessageFactory {
    private MessageFactory downstream;
    private Set<String> urns;
    private boolean inclusive;

    public FilterMessageFactory(MessageFactory downstream, Set<String> urns, boolean inclusive) {
        this.downstream = downstream;
        this.urns = urns;
        this.inclusive = inclusive;
    }

    @Override
    public String[] getKnownMessageURNs() {
        return this.downstream.getKnownMessageURNs();
    }

    @Override
    public Message makeMessage(String urn, InputStream data) throws IOException {
        if (this.inclusive && !this.urns.contains(urn)) {
            return null;
        }
        if (!this.inclusive && this.urns.contains(urn)) {
            return null;
        }
        return this.downstream.makeMessage(urn, data);
    }
}

