/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc.gui;

import java.awt.Graphics;
import rescuecore2.misc.Pair;

public final class DrawingTools {
    public static final double DEFAULT_ARROW_ANGLE = Math.toRadians(135.0);
    public static final double DEFAULT_ARROW_LENGTH = 5.0;
    public static final double DEFAULT_ARROW_DISTANCE = 0.5;

    private DrawingTools() {
    }

    public static Pair<Pair<Integer, Integer>, Pair<Integer, Integer>> getArrowHeads(int startX, int startY, int endX, int endY, double angle, double length, double d) {
        double dx = endX - startX;
        double dy = endY - startY;
        double headX = (double)startX + d * dx;
        double headY = (double)startY + d * dy;
        double vectorX = Math.cos(angle) * dx - Math.sin(angle) * dy;
        double vectorY = Math.sin(angle) * dx + Math.cos(angle) * dy;
        double vLength = Math.hypot(vectorX, vectorY);
        double leftX = headX + (vectorX /= vLength) * length;
        double leftY = headY + (vectorY /= vLength) * length;
        double rightX = headX - vectorY * length;
        double rightY = headY + vectorX * length;
        Pair<Integer, Integer> left = new Pair<Integer, Integer>((int)leftX, (int)leftY);
        Pair<Integer, Integer> right = new Pair<Integer, Integer>((int)rightX, (int)rightY);
        return new Pair<Pair<Integer, Integer>, Pair<Integer, Integer>>(left, right);
    }

    public static void drawArrowHeads(int startX, int startY, int endX, int endY, double angle, double length, double d, Graphics g) {
        Pair<Pair<Integer, Integer>, Pair<Integer, Integer>> barbs = DrawingTools.getArrowHeads(startX, startY, endX, endY, angle, length, d);
        int leftX = barbs.first().first();
        int leftY = barbs.first().second();
        int rightX = barbs.second().first();
        int rightY = barbs.second().second();
        double dx = endX - startX;
        double dy = endY - startY;
        int headX = (int)((double)startX + d * dx);
        int headY = (int)((double)startY + d * dy);
        g.drawLine(leftX, leftY, headX, headY);
        g.drawLine(rightX, rightY, headX, headY);
    }

    public static void drawArrowHeads(int startX, int startY, int endX, int endY, Graphics g) {
        DrawingTools.drawArrowHeads(startX, startY, endX, endY, DEFAULT_ARROW_ANGLE, 5.0, 0.5, g);
    }
}

