/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.config;

import rescuecore2.config.AbstractValueConstraint;
import rescuecore2.config.Config;

public class IntegerValueConstraint
extends AbstractValueConstraint {
    private int min;
    private int max;

    public IntegerValueConstraint(String key) {
        this(key, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerValueConstraint(String key, int min, int max) {
        super(key);
        this.min = min;
        this.max = max;
    }

    @Override
    public String getDescription() {
        if (this.min == Integer.MIN_VALUE && this.max == Integer.MAX_VALUE) {
            return "Must be an integer";
        }
        if (this.min == Integer.MIN_VALUE) {
            return "Must be an integer less than or equal to " + this.max;
        }
        if (this.max == Integer.MAX_VALUE) {
            return "Must be an integer greater than or equal to " + this.min;
        }
        return "Must be an integer between " + this.min + " and " + this.max + " inclusive";
    }

    @Override
    public boolean isValid(String value, Config config) {
        try {
            int i = Integer.parseInt(value);
            return i >= this.min && i <= this.max;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

