/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.config;

import rescuecore2.config.AbstractValueConstraint;
import rescuecore2.config.Config;

public class ClassNameSetValueConstraint
extends AbstractValueConstraint {
    private Class<?> required;
    private boolean allowUndefined;

    public ClassNameSetValueConstraint(String key) {
        this(key, null);
    }

    public ClassNameSetValueConstraint(String key, Class<?> required) {
        super(key);
        this.required = required;
        this.allowUndefined = true;
    }

    @Override
    public String getDescription() {
        if (this.required == null) {
            return "Must be a list of valid class names";
        }
        return "Must be a list of valid class names that extend " + this.required.getName();
    }

    @Override
    public boolean isValid(String value, Config config) {
        try {
            for (String next : config.getArrayValue(this.key)) {
                Class<?> c = Class.forName(next);
                if (this.required == null || this.required.isAssignableFrom(c)) continue;
                return false;
            }
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean undefinedIsValid() {
        return this.allowUndefined;
    }
}

