/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import maps.gml.GMLEdge;
import maps.gml.view.EdgeDecorator;
import rescuecore2.misc.gui.ScreenTransform;

public class LineEdgeDecorator
implements EdgeDecorator {
    private static final Stroke PASSABLE_STROKE = new BasicStroke(1.0f, 0, 2);
    private static final Stroke IMPASSABLE_STROKE = new BasicStroke(2.0f, 0, 2);
    private Color colour;

    public LineEdgeDecorator(Color colour) {
        this.colour = colour;
    }

    @Override
    public void decorate(GMLEdge edge, Graphics2D g, ScreenTransform transform) {
        int x1 = transform.xToScreen(edge.getStart().getX());
        int y1 = transform.yToScreen(edge.getStart().getY());
        int x2 = transform.xToScreen(edge.getEnd().getX());
        int y2 = transform.yToScreen(edge.getEnd().getY());
        g.setColor(this.colour);
        g.setStroke(edge.isPassable() ? PASSABLE_STROKE : IMPASSABLE_STROKE);
        g.drawLine(x1, y1, x2, y2);
    }
}

