/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import maps.gml.GMLBuilding;
import maps.gml.GMLEdge;
import maps.gml.GMLMap;
import maps.gml.GMLNode;
import maps.gml.GMLObject;
import maps.gml.GMLRoad;
import maps.gml.GMLSpace;
import maps.gml.editor.AbstractFunction;
import maps.gml.editor.GMLEditor;
import maps.gml.view.BuildingDecorator;
import maps.gml.view.DecoratorOverlay;
import maps.gml.view.EdgeDecorator;
import maps.gml.view.FilledShapeDecorator;
import maps.gml.view.LineEdgeDecorator;
import maps.gml.view.NodeDecorator;
import maps.gml.view.RoadDecorator;
import maps.gml.view.SpaceDecorator;
import maps.gml.view.SquareNodeDecorator;
import maps.validate.GMLMapValidator;
import maps.validate.MapValidator;
import maps.validate.ValidationError;
import rescuecore2.log.Logger;

public class ValidateFunction
extends AbstractFunction {
    private static final Color HIGHLIGHT_COLOUR = Color.RED;
    private static final int NODE_SIZE = 5;
    private DecoratorOverlay overlay = new DecoratorOverlay();
    private NodeDecorator nodeHighlight = new SquareNodeDecorator(HIGHLIGHT_COLOUR, 5);
    private EdgeDecorator edgeHighlight = new LineEdgeDecorator(HIGHLIGHT_COLOUR);
    private FilledShapeDecorator shapeHighlight = new FilledShapeDecorator(HIGHLIGHT_COLOUR, HIGHLIGHT_COLOUR, HIGHLIGHT_COLOUR);

    public ValidateFunction(GMLEditor editor) {
        super(editor);
    }

    @Override
    public void execute() {
        this.overlay.clearAllDecorators();
        ArrayList<ValidationError> allErrors = new ArrayList<ValidationError>();
        for (MapValidator<GMLMap> validator : GMLMapValidator.getDefaultValidators()) {
            Logger.info((String)("Validating " + validator));
            Collection<ValidationError> errors = validator.validate(this.editor.getMap());
            allErrors.addAll(errors);
            for (ValidationError e : errors) {
                System.out.println(e);
                this.addDecorator(e.getId());
            }
        }
        this.editor.getInspector().setErrors(allErrors);
        this.editor.getViewer().removeOverlay(this.overlay);
        this.editor.getViewer().addOverlay(this.overlay);
        this.editor.getViewer().repaint();
    }

    private void addDecorator(int id) {
        GMLObject obj = this.editor.getMap().getObject(id);
        if (obj == null) {
            return;
        }
        if (obj instanceof GMLBuilding) {
            this.overlay.setBuildingDecorator((BuildingDecorator)this.shapeHighlight, (GMLBuilding)obj);
        } else if (obj instanceof GMLRoad) {
            this.overlay.setRoadDecorator((RoadDecorator)this.shapeHighlight, (GMLRoad)obj);
        } else if (obj instanceof GMLSpace) {
            this.overlay.setSpaceDecorator((SpaceDecorator)this.shapeHighlight, (GMLSpace)obj);
        } else if (obj instanceof GMLEdge) {
            this.overlay.setEdgeDecorator(this.edgeHighlight, (GMLEdge)obj);
        } else if (obj instanceof GMLNode) {
            this.overlay.setNodeDecorator(this.nodeHighlight, (GMLNode)obj);
        }
    }

    @Override
    public String getName() {
        return "Validate map";
    }
}

