/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLBuilding;
import maps.gml.GMLCoordinates;
import maps.gml.GMLObject;
import maps.gml.GMLRoad;
import maps.gml.GMLShape;
import maps.gml.GMLSpace;
import maps.gml.editor.AbstractTool;
import maps.gml.editor.GMLEditor;
import maps.gml.view.BuildingDecorator;
import maps.gml.view.FilledShapeDecorator;
import maps.gml.view.RoadDecorator;
import maps.gml.view.SpaceDecorator;

public class DeleteShapeTool
extends AbstractTool {
    private static final Color HIGHLIGHT_COLOUR = Color.BLUE;
    private Listener listener = new Listener();
    private FilledShapeDecorator highlight = new FilledShapeDecorator(HIGHLIGHT_COLOUR, HIGHLIGHT_COLOUR, HIGHLIGHT_COLOUR);
    private GMLShape shape;

    public DeleteShapeTool(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Delete shape";
    }

    @Override
    public void activate() {
        this.editor.getViewer().addMouseListener(this.listener);
        this.editor.getViewer().addMouseMotionListener(this.listener);
        this.shape = null;
    }

    @Override
    public void deactivate() {
        this.editor.getViewer().removeMouseListener(this.listener);
        this.editor.getViewer().removeMouseMotionListener(this.listener);
        this.editor.getViewer().clearAllBuildingDecorators();
        this.editor.getViewer().clearAllRoadDecorators();
        this.editor.getViewer().clearAllSpaceDecorators();
        this.editor.getViewer().repaint();
    }

    private void highlightShape(GMLShape newShape) {
        if (this.shape == newShape) {
            return;
        }
        if (this.shape != null) {
            if (this.shape instanceof GMLBuilding) {
                this.editor.getViewer().clearBuildingDecorator((GMLBuilding)this.shape);
            }
            if (this.shape instanceof GMLRoad) {
                this.editor.getViewer().clearRoadDecorator((GMLRoad)this.shape);
            }
            if (this.shape instanceof GMLSpace) {
                this.editor.getViewer().clearSpaceDecorator((GMLSpace)this.shape);
            }
        }
        this.shape = newShape;
        if (this.shape != null) {
            if (this.shape instanceof GMLBuilding) {
                this.editor.getViewer().setBuildingDecorator((BuildingDecorator)this.highlight, (GMLBuilding)this.shape);
            }
            if (this.shape instanceof GMLRoad) {
                this.editor.getViewer().setRoadDecorator((RoadDecorator)this.highlight, (GMLRoad)this.shape);
            }
            if (this.shape instanceof GMLSpace) {
                this.editor.getViewer().setSpaceDecorator((SpaceDecorator)this.highlight, (GMLSpace)this.shape);
            }
        }
        this.editor.getViewer().repaint();
    }

    private class DeleteShapeEdit
    extends AbstractUndoableEdit {
        private GMLShape shape;

        public DeleteShapeEdit(GMLShape shape) {
            this.shape = shape;
        }

        @Override
        public void undo() {
            super.undo();
            DeleteShapeTool.this.editor.getMap().add((GMLObject)this.shape);
            DeleteShapeTool.this.editor.getViewer().repaint();
        }

        @Override
        public void redo() {
            super.redo();
            DeleteShapeTool.this.editor.getMap().remove((GMLObject)this.shape);
            DeleteShapeTool.this.editor.getViewer().repaint();
        }
    }

    private class Listener
    implements MouseListener,
    MouseMotionListener {
        private Listener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (DeleteShapeTool.this.shape != null && e.getButton() == 1) {
                DeleteShapeTool.this.editor.getMap().remove((GMLObject)DeleteShapeTool.this.shape);
                DeleteShapeTool.this.editor.getViewer().repaint();
                DeleteShapeTool.this.editor.setChanged();
                DeleteShapeTool.this.editor.addEdit(new DeleteShapeEdit(DeleteShapeTool.this.shape));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point p = this.fixEventPoint(e.getPoint());
            GMLCoordinates c = DeleteShapeTool.this.editor.snap(DeleteShapeTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y));
            DeleteShapeTool.this.highlightShape(DeleteShapeTool.this.editor.getMap().findShapeUnder(c.getX(), c.getY()));
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private Point fixEventPoint(Point p) {
            Insets insets = DeleteShapeTool.this.editor.getViewer().getInsets();
            return new Point(p.x - insets.left, p.y - insets.top);
        }
    }
}

