/*
 * Decompiled with CFR 0.152.
 */
package maps.convert.osm2gml;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import maps.convert.osm2gml.DirectedEdge;
import maps.convert.osm2gml.Edge;
import maps.convert.osm2gml.Node;
import maps.gml.GMLCoordinates;
import maps.gml.GMLTools;
import rescuecore2.misc.geometry.Point2D;

public abstract class TemporaryObject {
    private List<DirectedEdge> edges;
    private Map<DirectedEdge, TemporaryObject> neighbours;
    private Path2D path;
    private Rectangle2D bounds;

    protected TemporaryObject(List<DirectedEdge> edges) {
        this.edges = new ArrayList<DirectedEdge>(edges);
        this.neighbours = new HashMap<DirectedEdge, TemporaryObject>();
    }

    public List<DirectedEdge> getEdges() {
        return Collections.unmodifiableList(this.edges);
    }

    public TemporaryObject getNeighbour(DirectedEdge edge) {
        return this.neighbours.get(edge);
    }

    public void setNeighbour(DirectedEdge edge, TemporaryObject neighbour) {
        this.neighbours.put(edge, neighbour);
    }

    public void setNeighbour(Edge edge, TemporaryObject neighbour) {
        this.neighbours.put(this.findDirectedEdge(edge), neighbour);
    }

    public List<GMLCoordinates> makeGMLCoordinates() {
        ArrayList<GMLCoordinates> result = new ArrayList<GMLCoordinates>();
        for (DirectedEdge next : this.edges) {
            Point2D p = next.getStartCoordinates();
            result.add(new GMLCoordinates(p.getX(), p.getY()));
        }
        return result;
    }

    public Rectangle2D getBounds() {
        if (this.bounds == null) {
            this.bounds = GMLTools.getBounds(this.makeGMLCoordinates());
        }
        return this.bounds;
    }

    public Shape getShape() {
        if (this.path == null) {
            this.path = new Path2D.Double();
            Iterator<DirectedEdge> it = this.edges.iterator();
            DirectedEdge d = it.next();
            this.path.moveTo(d.getStartCoordinates().getX(), d.getStartCoordinates().getY());
            this.path.lineTo(d.getEndCoordinates().getX(), d.getEndCoordinates().getY());
            while (it.hasNext()) {
                d = it.next();
                this.path.lineTo(d.getEndCoordinates().getX(), d.getEndCoordinates().getY());
            }
        }
        return this.path;
    }

    public boolean isDuplicate(TemporaryObject other) {
        DirectedEdge b;
        DirectedEdge a;
        List<DirectedEdge> myEdges = this.getEdges();
        List<DirectedEdge> otherEdges = other.getEdges();
        if (myEdges.size() != otherEdges.size()) {
            return false;
        }
        Iterator<DirectedEdge> it = myEdges.iterator();
        DirectedEdge start = it.next();
        Iterator<DirectedEdge> ix = otherEdges.iterator();
        DirectedEdge otherStart = null;
        while (ix.hasNext()) {
            DirectedEdge test = ix.next();
            if (!test.equals(start)) continue;
            otherStart = test;
            break;
        }
        if (otherStart == null) {
            return false;
        }
        while (ix.hasNext()) {
            a = it.next();
            if (a.equals(b = ix.next())) continue;
            return false;
        }
        ix = otherEdges.iterator();
        while (it.hasNext()) {
            a = it.next();
            if (a.equals(b = ix.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEntirelyInside(TemporaryObject other) {
        if (!this.getBounds().intersects(other.getBounds())) {
            return false;
        }
        Area a = new Area(this.getShape());
        Area b = new Area(other.getShape());
        Area intersection = new Area(a);
        intersection.intersect(b);
        return a.equals(intersection);
    }

    protected void replaceEdge(Edge edge, Collection<Edge> replacements) {
        if (replacements.isEmpty()) {
            Iterator<DirectedEdge> it = this.edges.iterator();
            while (it.hasNext()) {
                DirectedEdge next = it.next();
                if (!next.getEdge().equals(edge)) continue;
                it.remove();
            }
        } else {
            ListIterator<DirectedEdge> it = this.edges.listIterator();
            while (it.hasNext()) {
                DirectedEdge next = it.next();
                if (!next.getEdge().equals(edge)) continue;
                it.remove();
                HashSet<Edge> replacementsSet = new HashSet<Edge>(replacements);
                Node start = next.getStartNode();
                Node end = next.getEndNode();
                while (!start.equals(end)) {
                    DirectedEdge newEdge = this.findNewEdge(start, replacementsSet);
                    replacementsSet.remove(newEdge.getEdge());
                    it.add(newEdge);
                    start = newEdge.getEndNode();
                }
                break;
            }
        }
        this.bounds = null;
        this.path = null;
    }

    private DirectedEdge findNewEdge(Node from, Set<Edge> candidates) {
        for (Edge next : candidates) {
            if (next.getStart().equals(from)) {
                return new DirectedEdge(next, true);
            }
            if (!next.getEnd().equals(from)) continue;
            return new DirectedEdge(next, false);
        }
        return null;
    }

    private DirectedEdge findDirectedEdge(Edge e) {
        for (DirectedEdge next : this.edges) {
            if (!next.getEdge().equals(e)) continue;
            return next;
        }
        throw new IllegalArgumentException("Edge " + e + " not found");
    }
}

