/*
 * Decompiled with CFR 0.152.
 */
package maps.convert.osm2gml;

import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import maps.convert.osm2gml.OSMShape;
import maps.osm.OSMBuilding;
import maps.osm.OSMMap;
import maps.osm.OSMNode;
import rescuecore2.misc.geometry.Point2D;

public class OSMBuildingInfo
implements OSMShape {
    private List<Point2D> vertices;
    private Area area;
    private long buildingID;

    public OSMBuildingInfo(OSMBuilding building, OSMMap map) {
        this.buildingID = building.getID();
        this.vertices = new ArrayList<Point2D>();
        for (Long next : building.getNodeIDs()) {
            OSMNode node = map.getNode(next);
            this.vertices.add(new Point2D(node.getLongitude(), node.getLatitude()));
        }
        Path2D.Double path = new Path2D.Double();
        Iterator<Point2D> it = this.vertices.iterator();
        Point2D point = it.next();
        path.moveTo(point.getX(), point.getY());
        while (it.hasNext()) {
            point = it.next();
            path.lineTo(point.getX(), point.getY());
        }
        path.closePath();
        this.area = new Area(path.createTransformedShape(null));
    }

    @Override
    public List<Point2D> getVertices() {
        return this.vertices;
    }

    @Override
    public Area getArea() {
        return this.area;
    }

    public long getBuildingID() {
        return this.buildingID;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("BuildingInfo [");
        Iterator<Point2D> it = this.vertices.iterator();
        while (it.hasNext()) {
            result.append(it.next().toString());
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }
}

