/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import rescuecore2.log.Logger;
import rescuecore2.messages.Command;
import rescuecore2.registry.EntityFactory;
import rescuecore2.registry.FilterEntityFactory;
import rescuecore2.registry.FilterPropertyFactory;
import rescuecore2.registry.PropertyFactory;
import rescuecore2.registry.Registry;
import rescuecore2.standard.entities.Civilian;
import rescuecore2.standard.entities.StandardEntityFactory;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.entities.StandardPropertyFactory;
import rescuecore2.standard.entities.StandardPropertyURN;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import sample.AbstractSampleAgent;

public class SampleCivilian
extends AbstractSampleAgent<Civilian> {
    private static final double DEFAULT_HELP_PROBABILITY = 0.1;
    private static final double DEFAULT_OUCH_PROBABILITY = 0.1;
    private static final int DEFAULT_CONSCIOUS_THRESHOLD = 2500;
    private static final String HELP_PROBABILITY_KEY = "civilian.help.probability";
    private static final String OUCH_PROBABILITY_KEY = "civilian.ouch.probability";
    private static final String CONSCIOUS_THRESHOLD_KEY = "civilian.conscious.threshold";
    private static final String OUCH = "Ouch";
    private static final String HELP = "Help";
    private double helpProbability;
    private double ouchProbability;
    private int consciousThreshold;

    public String toString() {
        return "Sample civilian";
    }

    @Override
    protected void postConnect() {
        super.postConnect();
        this.helpProbability = this.config.getFloatValue(HELP_PROBABILITY_KEY, 0.1);
        this.ouchProbability = this.config.getFloatValue(OUCH_PROBABILITY_KEY, 0.1);
        this.consciousThreshold = this.config.getIntValue(CONSCIOUS_THRESHOLD_KEY, 2500);
        Logger.info((String)("Civilian " + this.getID() + " connected"));
        Civilian me = (Civilian)this.me();
        ((StandardWorldModel)this.model).removeAllEntities();
        ((StandardWorldModel)this.model).addEntity((Entity)me);
    }

    public Registry getPreferredRegistry(Registry parent) {
        Registry result = new Registry("SampleCivilian filter registry", super.getPreferredRegistry(parent));
        HashSet<String> entityURNs = new HashSet<String>();
        entityURNs.add(StandardEntityURN.BUILDING.toString());
        entityURNs.add(StandardEntityURN.REFUGE.toString());
        entityURNs.add(StandardEntityURN.ROAD.toString());
        entityURNs.add(StandardEntityURN.CIVILIAN.toString());
        HashSet<String> propertyURNs = new HashSet<String>();
        propertyURNs.add(StandardPropertyURN.X.toString());
        propertyURNs.add(StandardPropertyURN.Y.toString());
        propertyURNs.add(StandardPropertyURN.EDGES.toString());
        propertyURNs.add(StandardPropertyURN.DAMAGE.toString());
        propertyURNs.add(StandardPropertyURN.BURIEDNESS.toString());
        propertyURNs.add(StandardPropertyURN.HP.toString());
        propertyURNs.add(StandardPropertyURN.POSITION.toString());
        result.registerEntityFactory((EntityFactory)new FilterEntityFactory((EntityFactory)StandardEntityFactory.INSTANCE, entityURNs, true));
        result.registerPropertyFactory((PropertyFactory)new FilterPropertyFactory((PropertyFactory)StandardPropertyFactory.INSTANCE, propertyURNs, true));
        return result;
    }

    protected void think(int time, ChangeSet changed, Collection<Command> heard) {
        int buriedness;
        Civilian me = (Civilian)this.me();
        ((StandardWorldModel)this.model).removeAllEntities();
        ((StandardWorldModel)this.model).addEntity((Entity)me);
        int damage = me.isDamageDefined() ? me.getDamage() : 0;
        int hp = me.isHPDefined() ? me.getHP() : 0;
        int n = buriedness = me.isBuriednessDefined() ? me.getBuriedness() : 0;
        if (hp <= 0 || hp < this.consciousThreshold) {
            Logger.info((String)"Unconcious or dead");
            this.sendRest(time);
            return;
        }
        if (damage > 0 && this.random.nextDouble() < this.ouchProbability) {
            Logger.info((String)"Shouting in pain");
            this.say(OUCH, time);
        }
        if (buriedness > 0 && this.random.nextDouble() < this.helpProbability) {
            Logger.info((String)"Calling for help");
            this.say(HELP, time);
        }
        if (damage == 0 && buriedness == 0) {
            List<EntityID> path = this.search.breadthFirstSearch(((Civilian)this.me()).getPosition(), this.refugeIDs);
            if (path != null) {
                Logger.info((String)"Heading for a refuge");
                this.sendMove(time, path);
                return;
            }
            Logger.info((String)"Moving randomly");
            this.sendMove(time, this.randomWalk());
            return;
        }
        Logger.info((String)("Not moving: damage = " + damage + ", buriedness = " + buriedness));
        this.sendRest(time);
    }

    protected EnumSet<StandardEntityURN> getRequestedEntityURNsEnum() {
        return EnumSet.of(StandardEntityURN.CIVILIAN);
    }

    protected boolean shouldIndex() {
        return false;
    }

    private void say(String message, int time) {
        try {
            if (this.useSpeak) {
                this.sendSpeak(time, 0, message.getBytes("UTF-8"));
            } else {
                this.sendSay(time, message.getBytes("UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("This should not have happened!", e);
        }
    }
}

