/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import rescuecore2.log.Logger;
import rescuecore2.messages.Command;
import rescuecore2.standard.entities.AmbulanceTeam;
import rescuecore2.standard.entities.Civilian;
import rescuecore2.standard.entities.Human;
import rescuecore2.standard.entities.Refuge;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.EntityID;
import sample.AbstractSampleAgent;
import sample.DistanceSorter;

public class SampleAmbulanceTeam
extends AbstractSampleAgent<AmbulanceTeam> {
    private Collection<EntityID> unexploredBuildings;

    public String toString() {
        return "Sample ambulance team";
    }

    @Override
    protected void postConnect() {
        super.postConnect();
        ((StandardWorldModel)this.model).indexClass(new StandardEntityURN[]{StandardEntityURN.CIVILIAN, StandardEntityURN.FIRE_BRIGADE, StandardEntityURN.POLICE_FORCE, StandardEntityURN.AMBULANCE_TEAM, StandardEntityURN.REFUGE, StandardEntityURN.BUILDING});
        this.unexploredBuildings = new HashSet<EntityID>(this.buildingIDs);
    }

    protected void think(int time, ChangeSet changed, Collection<Command> heard) {
        List<EntityID> path;
        if (time == this.config.getIntValue("kernel.agents.ignoreuntil")) {
            this.sendSubscribe(time, new int[]{1});
        }
        for (Command command : heard) {
            Logger.debug((String)("Heard " + command));
        }
        this.updateUnexploredBuildings(changed);
        if (this.someoneOnBoard()) {
            if (this.location() instanceof Refuge) {
                Logger.info((String)"Unloading");
                this.sendUnload(time);
                return;
            }
            path = this.search.breadthFirstSearch(((AmbulanceTeam)this.me()).getPosition(), this.refugeIDs);
            if (path != null) {
                Logger.info((String)"Moving to refuge");
                this.sendMove(time, path);
                return;
            }
            Logger.debug((String)"Failed to plan path to refuge");
        }
        for (Human human : this.getTargets()) {
            if (human.getPosition().equals((Object)this.location().getID())) {
                if (human instanceof Civilian && human.getBuriedness() == 0 && !(this.location() instanceof Refuge)) {
                    Logger.info((String)("Loading " + human));
                    this.sendLoad(time, human.getID());
                    return;
                }
                if (human.getBuriedness() <= 0) continue;
                Logger.info((String)("Rescueing " + human));
                this.sendRescue(time, human.getID());
                return;
            }
            List<EntityID> path2 = this.search.breadthFirstSearch(((AmbulanceTeam)this.me()).getPosition(), human.getPosition());
            if (path2 == null) continue;
            Logger.info((String)"Moving to target");
            this.sendMove(time, path2);
            return;
        }
        path = this.search.breadthFirstSearch(((AmbulanceTeam)this.me()).getPosition(), this.unexploredBuildings);
        if (path != null) {
            Logger.info((String)"Searching buildings");
            this.sendMove(time, path);
            return;
        }
        Logger.info((String)"Moving randomly");
        this.sendMove(time, this.randomWalk());
    }

    protected EnumSet<StandardEntityURN> getRequestedEntityURNsEnum() {
        return EnumSet.of(StandardEntityURN.AMBULANCE_TEAM);
    }

    private boolean someoneOnBoard() {
        for (StandardEntity next : ((StandardWorldModel)this.model).getEntitiesOfType(StandardEntityURN.CIVILIAN)) {
            if (!((Human)next).getPosition().equals((Object)this.getID())) continue;
            Logger.debug((String)(next + " is on board"));
            return true;
        }
        return false;
    }

    private List<Human> getTargets() {
        ArrayList<Human> targets = new ArrayList<Human>();
        for (StandardEntity next : ((StandardWorldModel)this.model).getEntitiesOfType(new StandardEntityURN[]{StandardEntityURN.CIVILIAN, StandardEntityURN.FIRE_BRIGADE, StandardEntityURN.POLICE_FORCE, StandardEntityURN.AMBULANCE_TEAM})) {
            Human h = (Human)next;
            if (h == this.me() || !h.isHPDefined() || !h.isBuriednessDefined() || !h.isDamageDefined() || !h.isPositionDefined() || h.getHP() <= 0 || h.getBuriedness() <= 0 && h.getDamage() <= 0) continue;
            targets.add(h);
        }
        Collections.sort(targets, new DistanceSorter(this.location(), (StandardWorldModel)this.model));
        return targets;
    }

    private void updateUnexploredBuildings(ChangeSet changed) {
        for (EntityID next : changed.getChangedEntities()) {
            this.unexploredBuildings.remove(next);
        }
    }
}

