/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import rescuecore2.config.Config;
import rescuecore2.misc.gui.ScreenTransform;
import rescuecore2.standard.entities.Human;
import rescuecore2.standard.view.StandardEntityViewLayer;

public class PositionHistoryLayer
extends StandardEntityViewLayer<Human> {
    private static final Color PATH_COLOUR = Color.RED;

    public PositionHistoryLayer() {
        super(Human.class);
    }

    public void initialise(Config config) {
    }

    public String getName() {
        return "Position history";
    }

    @Override
    public Shape render(Human h, Graphics2D g, ScreenTransform t) {
        if (!h.isPositionHistoryDefined()) {
            return null;
        }
        int[] history = h.getPositionHistory();
        if (history.length < 4) {
            return null;
        }
        g.setColor(PATH_COLOUR);
        int x = t.xToScreen((double)history[0]);
        int y = t.yToScreen((double)history[1]);
        for (int i = 2; i < history.length; i += 2) {
            int x2 = t.xToScreen((double)history[i]);
            int y2 = t.yToScreen((double)history[i + 1]);
            g.drawLine(x, y, x2, y2);
            x = x2;
            y = y2;
        }
        return null;
    }
}

