/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.score;

import rescuecore2.Timestep;
import rescuecore2.config.Config;
import rescuecore2.score.AbstractScoreFunction;
import rescuecore2.standard.entities.Civilian;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.WorldModel;

public class HealthScoreFunction
extends AbstractScoreFunction {
    private static final String ABSOLUTE_KEY = "score.standard.health.absolute";
    private static final double MAX = 10000.0;
    private boolean absolute;

    public HealthScoreFunction() {
        super("Civilian health");
    }

    public void initialise(WorldModel<? extends Entity> world, Config config) {
        this.absolute = config.getBooleanValue(ABSOLUTE_KEY, false);
        this.setName(this.absolute ? "Civilian health (absolute)" : "Civilian health (proportion)");
    }

    public double score(WorldModel<? extends Entity> world, Timestep timestep) {
        double sum = 0.0;
        double max = 0.0;
        for (Entity next : world) {
            if (!(next instanceof Civilian)) continue;
            Civilian c = (Civilian)next;
            if (c.isHPDefined()) {
                sum += (double)c.getHP();
            }
            max += 10000.0;
        }
        if (this.absolute) {
            return sum;
        }
        return sum / max;
    }
}

