/*
 * Decompiled with CFR 0.152.
 */
package kernel;

import java.util.Collection;
import java.util.Iterator;
import kernel.KernelState;
import kernel.TerminationCondition;
import rescuecore2.config.Config;

public class OrTerminationCondition
implements TerminationCondition {
    private Collection<TerminationCondition> children;

    public OrTerminationCondition(Collection<TerminationCondition> children) {
        if (children == null || children.size() == 0) {
            throw new IllegalArgumentException("Must have at least one child");
        }
        this.children = children;
    }

    @Override
    public boolean shouldStop(KernelState state) {
        for (TerminationCondition next : this.children) {
            if (!next.shouldStop(state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initialise(Config config) {
        for (TerminationCondition next : this.children) {
            next.initialise(config);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        Iterator<TerminationCondition> it = this.children.iterator();
        while (it.hasNext()) {
            result.append(it.next());
            if (!it.hasNext()) continue;
            result.append(" | ");
        }
        return result.toString();
    }
}

