/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools.simulationrunner;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import rescuecore.tools.simulationrunner.LogReader;

public class RescueProcess {
    private String name;
    private String commandline;
    private String done;
    private String logPrefix;
    private boolean useOut;
    private Process process;
    private LogReader out;
    private LogReader error;

    public RescueProcess(String name, String commandline, String started, String logPrefix) {
        this.name = name;
        this.commandline = commandline;
        this.done = started;
        this.logPrefix = logPrefix;
        this.useOut = true;
        if (this.done.startsWith("stderr:")) {
            this.done = this.done.substring(7);
            this.useOut = false;
        }
    }

    public String toString() {
        return this.name + ": " + this.commandline + " -> " + this.done;
    }

    public String getName() {
        return this.name;
    }

    public String getCommandLine() {
        return this.commandline;
    }

    public String getStartedFlag() {
        return this.done;
    }

    public synchronized boolean start() {
        try {
            System.out.println("Executing " + this.commandline);
            this.process = Runtime.getRuntime().exec(this.commandline);
            InputStream output = this.process.getInputStream();
            InputStream errors = this.process.getErrorStream();
            this.out = new LogReader(output, this.logPrefix == null ? null : new BufferedOutputStream(new FileOutputStream(new File(this.logPrefix + this.name + ".log"))));
            this.error = new LogReader(errors, this.logPrefix == null ? null : new BufferedOutputStream(new FileOutputStream(new File(this.logPrefix + this.name + ".error"))));
        }
        catch (IOException e) {
            System.err.println("Could not start process: " + this.commandline);
            e.printStackTrace();
            if (this.process != null) {
                this.process.destroy();
            }
            return false;
        }
        if (this.useOut) {
            this.out.start(this.done, this);
            this.error.start();
        } else {
            this.out.start();
            this.error.start(this.done, this);
        }
        return true;
    }

    public void addOutputDestination(OutputStream stream) {
        this.out.addOutputStream(stream);
    }

    public void addErrorDestination(OutputStream stream) {
        this.error.addOutputStream(stream);
    }

    public synchronized boolean isRunning() {
        if (this.process == null) {
            return false;
        }
        try {
            this.process.exitValue();
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
        return false;
    }

    public synchronized void stop() {
        if (this.process == null) {
            return;
        }
        this.out.kill();
        this.error.kill();
        this.process.destroy();
        this.process = null;
    }
}

