/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import rescuecore.HashMemory;
import rescuecore.RescueObject;
import rescuecore.objects.AmbulanceCenter;
import rescuecore.objects.AmbulanceTeam;
import rescuecore.objects.Building;
import rescuecore.objects.Civilian;
import rescuecore.objects.FireBrigade;
import rescuecore.objects.FireStation;
import rescuecore.objects.Node;
import rescuecore.objects.PoliceForce;
import rescuecore.objects.PoliceOffice;
import rescuecore.objects.Refuge;
import rescuecore.objects.Road;
import rescuecore.tools.MapFiles;

public class RandomConfig {
    private Node[] allNodes;
    private Road[] allRoads;
    private Building[] allBuildings;

    public static void main(String[] args) {
        new RandomConfig(args);
    }

    RandomConfig(String[] args) {
        Limits fireBrigades = new Limits(10, 15, "fireBrigades", "fire brigades");
        Limits policeForces = new Limits(10, 15, "policeForces", "police forces");
        Limits ambulanceTeams = new Limits(5, 8, "ambulanceTeams", "ambulance teams");
        Limits fireStations = new Limits(1, 1, "fireStations", "fire stations");
        Limits policeStations = new Limits(1, 1, "policeStations", "police stations");
        Limits ambulanceCenters = new Limits(1, 1, "ambulanceCenters", "ambulance centers");
        Limits civilians = new Limits(70, 90, "civilians", "civilians");
        Limits refuges = new Limits(1, 5, "refuges", "refuges");
        Limits fires = new Limits(2, 8, "fires", "fires");
        Limits fireRadius = new Limits(0, 20000, "fireradius", "fire radius");
        Limits[] allLimits = new Limits[]{fireBrigades, policeForces, ambulanceTeams, fireStations, policeStations, ambulanceCenters, civilians, refuges, fires, fireRadius};
        boolean allowTrappedAgents = false;
        boolean bigFires = false;
        boolean trappedCivilians = true;
        String dir = "";
        for (int i = 0; i < args.length; ++i) {
            int j;
            if (args[i].startsWith("-min-")) {
                for (j = 0; j < allLimits.length; ++j) {
                    if (!args[i].equalsIgnoreCase("-min-" + allLimits[j].prefix)) continue;
                    allLimits[j].min = Integer.parseInt(args[++i]);
                }
                continue;
            }
            if (args[i].startsWith("-max-")) {
                for (j = 0; j < allLimits.length; ++j) {
                    if (!args[i].equalsIgnoreCase("-max-" + allLimits[j].prefix)) continue;
                    allLimits[j].max = Integer.parseInt(args[++i]);
                }
                continue;
            }
            if (args[i].startsWith("-no-")) {
                for (j = 0; j < allLimits.length; ++j) {
                    if (!args[i].equalsIgnoreCase("-no-" + allLimits[j].prefix)) continue;
                    allLimits[j].min = 0;
                    allLimits[j].max = 0;
                }
                continue;
            }
            if (args[i].startsWith("-set-")) {
                int num = Integer.parseInt(args[i + 1]);
                for (int j2 = 0; j2 < allLimits.length; ++j2) {
                    if (!args[i].equalsIgnoreCase("-set-" + allLimits[j2].prefix)) continue;
                    allLimits[j2].min = num;
                    allLimits[j2].max = num;
                }
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-t") || args[i].equalsIgnoreCase("--allow-trapped-agents")) {
                allowTrappedAgents = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-c") || args[i].equalsIgnoreCase("--allow-untrapped-civilians")) {
                trappedCivilians = false;
                continue;
            }
            if (args[i].equalsIgnoreCase("-b") || args[i].equalsIgnoreCase("--big-fires")) {
                bigFires = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-d") || args[i].equalsIgnoreCase("--dir")) {
                dir = args[i + 1];
                continue;
            }
            if (!args[i].equalsIgnoreCase("-h") && !args[i].equalsIgnoreCase("--help")) continue;
            System.out.println("Usage: RandomConfig [options]");
            System.out.println("This program will read from \"road.bin\", \"node.bin\" and \"building.bin\" and produce a randomised \"gisini.txt\"");
            System.out.println("Options");
            System.out.println("=======");
            for (j = 0; j < allLimits.length; ++j) {
                System.out.println("-min-" + allLimits[j].prefix + "\tSet the minimum number of " + allLimits[j].name + " (currently " + allLimits[j].min + ")");
                System.out.println("-max-" + allLimits[j].prefix + "\tSet the maximum number of " + allLimits[j].name + " (currently " + allLimits[j].max + ")");
                System.out.println("-no-" + allLimits[j].prefix + "\tSet the minimum and maximum of " + allLimits[j].name + " to zero");
            }
            System.out.println("-t\t--allow-trapped-agents\tAllow rescue agents (fire brigades, police forces and ambulance teams) to be placed inside buildings (default OFF)");
            System.out.println("-c\t--allow-untrapped-civilians\tAllow civilians to be placed outside buildings (default OFF)");
            System.out.println("-b\t--big-fires\tAllow big fires");
            System.out.println("-d\t--dir\tSet output directory (use full path)");
            System.out.println("-h\t--help\tPrint this message");
            return;
        }
        try {
            int i;
            File parentDir = new File(dir);
            File gisini = new File(parentDir, "gisini.txt");
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(gisini)));
            this.allNodes = MapFiles.loadNodes(parentDir);
            this.allRoads = MapFiles.loadRoads(parentDir);
            this.allBuildings = MapFiles.loadBuildings(parentDir);
            HashMemory memory = new HashMemory();
            for (i = 0; i < this.allNodes.length; ++i) {
                memory.add(this.allNodes[i], 0);
            }
            for (i = 0; i < this.allRoads.length; ++i) {
                memory.add(this.allRoads[i], 0);
            }
            for (i = 0; i < this.allBuildings.length; ++i) {
                memory.add(this.allBuildings[i], 0);
            }
            int numFireBrigades = fireBrigades.getNumber();
            int numPoliceForces = policeForces.getNumber();
            int numAmbulanceTeams = ambulanceTeams.getNumber();
            int numFireStations = fireStations.getNumber();
            int numPoliceStations = policeStations.getNumber();
            int numAmbulanceCenters = ambulanceCenters.getNumber();
            int numRefuges = refuges.getNumber();
            int numCivilians = civilians.getNumber();
            int numFires = fires.getNumber();
            FireStation[] fireStationBuildings = new FireStation[numFireStations];
            PoliceOffice[] policeOfficeBuildings = new PoliceOffice[numPoliceStations];
            AmbulanceCenter[] ambulanceCenterBuildings = new AmbulanceCenter[numAmbulanceCenters];
            Refuge[] refugeBuildings = new Refuge[numRefuges];
            Building[] normalBuildings = RandomConfig.placeMotionlessObjects(fireStationBuildings, policeOfficeBuildings, ambulanceCenterBuildings, refugeBuildings, this.allBuildings);
            MapFiles.writeGISMotionlessObjects(out, fireStationBuildings, policeOfficeBuildings, ambulanceCenterBuildings, refugeBuildings);
            FireBrigade[] fireBrigadeObjects = new FireBrigade[numFireBrigades];
            PoliceForce[] policeForceObjects = new PoliceForce[numPoliceForces];
            AmbulanceTeam[] ambulanceTeamObjects = new AmbulanceTeam[numAmbulanceTeams];
            Civilian[] civilianObjects = new Civilian[numCivilians];
            RandomConfig.placeMovingObjects(fireBrigadeObjects, policeForceObjects, ambulanceTeamObjects, civilianObjects, this.allBuildings, new Road[0], this.allNodes, allowTrappedAgents, trappedCivilians);
            MapFiles.writeGISMovingObjects(out, fireBrigadeObjects, policeForceObjects, ambulanceTeamObjects, civilianObjects, memory);
            Building[] fireBuildings = bigFires ? RandomConfig.placeBigFires(numFires, normalBuildings, fireRadius) : RandomConfig.placeNormalFires(numFires, normalBuildings);
            MapFiles.writeGISFires(out, fireBuildings);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Building[] placeMotionlessObjects(FireStation[] fire, PoliceOffice[] police, AmbulanceCenter[] ambulance, Refuge[] refuge, Building[] allBuildings) {
        Building a;
        Building location;
        int i;
        ArrayList<Building> remaining = new ArrayList<Building>();
        for (int i2 = 0; i2 < allBuildings.length; ++i2) {
            remaining.add(allBuildings[i2]);
        }
        Collections.shuffle(remaining);
        System.out.println("Placing " + ambulance.length + " ambulance centers");
        Iterator it = remaining.iterator();
        for (i = 0; i < ambulance.length; ++i) {
            location = (Building)it.next();
            it.remove();
            a = new AmbulanceCenter(location);
            a.setID(location.getID());
            ambulance[i] = a;
        }
        System.out.println("Placing " + fire.length + " fire stations");
        for (i = 0; i < fire.length; ++i) {
            location = (Building)it.next();
            it.remove();
            a = new FireStation(location);
            a.setID(location.getID());
            fire[i] = a;
        }
        System.out.println("Placing " + police.length + " police stations");
        for (i = 0; i < police.length; ++i) {
            location = (Building)it.next();
            it.remove();
            a = new PoliceOffice(location);
            a.setID(location.getID());
            police[i] = a;
        }
        System.out.println("Placing " + refuge.length + " refuges");
        for (i = 0; i < refuge.length; ++i) {
            location = (Building)it.next();
            it.remove();
            a = new Refuge(location);
            a.setID(location.getID());
            refuge[i] = a;
        }
        return remaining.toArray(new Building[0]);
    }

    public static void placeMovingObjects(FireBrigade[] fire, PoliceForce[] police, AmbulanceTeam[] ambulance, Civilian[] civ, Building[] b, Road[] r, Node[] n, boolean allowTrappedAgents, boolean trappedCivilians) {
        int i;
        RescueObject[] allLocations = new RescueObject[b.length + r.length + n.length];
        System.arraycopy(b, 0, allLocations, 0, b.length);
        System.arraycopy(r, 0, allLocations, b.length, r.length);
        System.arraycopy(n, 0, allLocations, b.length + r.length, n.length);
        RescueObject[] outsideLocations = new RescueObject[r.length + n.length];
        System.arraycopy(r, 0, outsideLocations, 0, r.length);
        System.arraycopy(n, 0, outsideLocations, r.length, n.length);
        System.out.println("Placing " + civ.length + " civilians");
        for (i = 0; i < civ.length; ++i) {
            civ[i] = new Civilian();
            civ[i].setPosition(RandomConfig.randomLocation(trappedCivilians ? b : allLocations).getID(), 0, null);
        }
        System.out.println("Placing " + ambulance.length + " ambulance teams");
        for (i = 0; i < ambulance.length; ++i) {
            ambulance[i] = new AmbulanceTeam();
            ambulance[i].setPosition(RandomConfig.randomLocation(allowTrappedAgents ? allLocations : outsideLocations).getID(), 0, null);
        }
        System.out.println("Placing " + fire.length + " fire brigades");
        for (i = 0; i < fire.length; ++i) {
            fire[i] = new FireBrigade();
            fire[i].setPosition(RandomConfig.randomLocation(allowTrappedAgents ? allLocations : outsideLocations).getID(), 0, null);
        }
        System.out.println("Placing " + police.length + " police forces");
        for (i = 0; i < police.length; ++i) {
            police[i] = new PoliceForce();
            police[i].setPosition(RandomConfig.randomLocation(allowTrappedAgents ? allLocations : outsideLocations).getID(), 0, null);
        }
    }

    public static Building[] placeNormalFires(int num, Building[] b) {
        ArrayList<Building> remaining = new ArrayList<Building>();
        for (int i = 0; i < b.length; ++i) {
            remaining.add(b[i]);
        }
        Collections.shuffle(remaining);
        Building[] result = new Building[num];
        System.out.println("Placing " + num + " fires");
        Iterator it = remaining.iterator();
        for (int i = 0; i < num; ++i) {
            result[i] = (Building)it.next();
        }
        return result;
    }

    public static Building[] placeBigFires(int num, Building[] b, Limits radius) {
        ArrayList<Building> remaining = new ArrayList<Building>();
        for (int i = 0; i < b.length; ++i) {
            remaining.add(b[i]);
        }
        Collections.shuffle(remaining);
        HashSet<Building> fires = new HashSet<Building>();
        System.out.print("Placing " + num + " big fires");
        Iterator it = remaining.iterator();
        for (int i = 0; i < num; ++i) {
            Building center = (Building)it.next();
            fires.add(center);
            long r = radius.getNumber();
            long distanceSquared = r * r;
            for (int j = 0; j < b.length; ++j) {
                long dy;
                long dx = center.getX() - b[j].getX();
                long distance = dx * dx + (dy = (long)(center.getY() - b[j].getY())) * dy;
                if (distance > distanceSquared) continue;
                fires.add(b[j]);
            }
        }
        return fires.toArray(new Building[0]);
    }

    public static RescueObject randomLocation(RescueObject[] possible) {
        return possible[(int)(Math.random() * (double)possible.length)];
    }

    private class Limits {
        int min;
        int max;
        String prefix;
        String name;

        Limits(int min, int max, String prefix, String name) {
            this.min = min;
            this.max = max;
            this.prefix = prefix;
            this.name = name;
        }

        int getNumber() {
            if (this.min == this.max) {
                return this.min;
            }
            int range = this.max - this.min;
            return (int)(Math.random() * (double)range) + this.min;
        }
    }
}

