/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools;

import java.util.HashMap;
import rescuecore.objects.Building;
import rescuecore.objects.Node;
import rescuecore.objects.Road;
import rescuecore.tools.MapFiles;

public class FixIDs {
    private static final String source = "FixIDs";

    public static void main(String[] args) {
        try {
            Road[] roads = MapFiles.loadRoads("road.bin");
            Node[] nodes = MapFiles.loadNodes("node.bin");
            Building[] buildings = MapFiles.loadBuildings("building.bin");
            FixIDs.fixIDs(roads, nodes, buildings);
            MapFiles.writeBuildings("building.bin", buildings);
            MapFiles.writeRoads("road.bin", roads);
            MapFiles.writeNodes("node.bin", nodes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void fixIDs(Road[] roads, Node[] nodes, Building[] buildings) {
        int i;
        int nextID = 1;
        HashMap<Integer, Integer> idMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Node> nodeMap = new HashMap<Integer, Node>();
        for (i = 0; i < roads.length; ++i) {
            roads[i].setID(nextID++);
        }
        for (i = 0; i < buildings.length; ++i) {
            buildings[i].setID(nextID++);
        }
        for (i = 0; i < nodes.length; ++i) {
            idMap.put(nodes[i].getID(), nextID);
            nodes[i].setID(nextID++);
            nodes[i].clearEdges(0, null);
            nodeMap.put(nodes[i].getID(), nodes[i]);
        }
        for (i = 0; i < roads.length; ++i) {
            int headID = (Integer)idMap.get(roads[i].getHead());
            int tailID = (Integer)idMap.get(roads[i].getTail());
            roads[i].setHead((Integer)idMap.get(roads[i].getHead()), 0, null);
            roads[i].setTail((Integer)idMap.get(roads[i].getTail()), 0, null);
            Node head = (Node)nodeMap.get(roads[i].getHead());
            Node tail = (Node)nodeMap.get(roads[i].getTail());
            head.appendEdge(roads[i].getID(), 0, null);
            tail.appendEdge(roads[i].getID(), 0, null);
        }
        for (i = 0; i < buildings.length; ++i) {
            int[] entrances = buildings[i].getEntrances();
            for (int j = 0; j < entrances.length; ++j) {
                entrances[j] = (Integer)idMap.get(entrances[j]);
                Node node = (Node)nodeMap.get(entrances[j]);
                node.appendEdge(buildings[i].getID(), 0, null);
            }
            buildings[i].setEntrances(entrances, 0, null);
        }
        for (i = 0; i < nodes.length; ++i) {
            int j;
            int shortcutSize;
            Node next = nodes[i];
            int numEdges = next.getEdges().length;
            int pocketSize = next.getPocketToTurnAcross().length;
            int timingSize = next.getSignalTiming().length;
            for (shortcutSize = next.getShortcutToTurn().length; shortcutSize < numEdges; ++shortcutSize) {
                next.appendShortcutToTurn(0, 0, null);
            }
            while (pocketSize < numEdges * 2) {
                next.appendPocketToTurnAcross(0, 0, null);
                ++pocketSize;
            }
            while (timingSize < numEdges * 3) {
                next.appendSignalTiming(0, 0, null);
                ++timingSize;
            }
            if (shortcutSize > numEdges) {
                next.clearShortcutToTurn(0, null);
                for (j = 0; j < numEdges; ++j) {
                    next.appendShortcutToTurn(0, 0, null);
                }
            }
            if (pocketSize > numEdges * 2) {
                next.clearPocketToTurnAcross(0, null);
                for (j = 0; j < numEdges * 2; ++j) {
                    next.appendPocketToTurnAcross(0, 0, null);
                }
            }
            if (timingSize <= numEdges * 3) continue;
            next.clearSignalTiming(0, null);
            for (j = 0; j < numEdges * 3; ++j) {
                next.appendSignalTiming(0, 0, null);
            }
        }
    }
}

