/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.objects;

import rescuecore.ArrayProperty;
import rescuecore.IntProperty;
import rescuecore.Property;
import rescuecore.objects.Vertex;

public class Node
extends Vertex {
    private IntProperty signal;
    private ArrayProperty shortcut;
    private ArrayProperty pocket;
    private ArrayProperty timing;

    public Node() {
        this.signal = new IntProperty(21);
        this.shortcut = new ArrayProperty(22);
        this.pocket = new ArrayProperty(23);
        this.timing = new ArrayProperty(24);
    }

    public Node(int x, int y) {
        this(x, y, new int[0], false, new int[0], new int[0], new int[0]);
    }

    public Node(int x, int y, int[] edges, boolean signal, int[] shortcut, int[] pocket, int[] timing) {
        super(x, y, edges);
        this.signal = new IntProperty(21, signal);
        this.shortcut = new ArrayProperty(22, shortcut);
        this.pocket = new ArrayProperty(23, pocket);
        this.timing = new ArrayProperty(24, timing);
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public Property getProperty(int property) {
        switch (property) {
            case 21: {
                return this.signal;
            }
            case 22: {
                return this.shortcut;
            }
            case 23: {
                return this.pocket;
            }
            case 24: {
                return this.timing;
            }
        }
        return super.getProperty(property);
    }

    public boolean hasSignal() {
        return this.signal.getValue() != 0;
    }

    public boolean setSignal(boolean b, int timestamp, Object source) {
        if (this.signal.updateValue(b ? 1 : 0, timestamp, source)) {
            this.firePropertyChanged(21, timestamp, source);
            return true;
        }
        return false;
    }

    public int[] getShortcutToTurn() {
        return this.shortcut.getValues();
    }

    public boolean setShortcutToTurn(int[] s, int timestamp, Object source) {
        if (this.shortcut.updateValues(s, timestamp, source)) {
            this.firePropertyChanged(22, timestamp, source);
            return true;
        }
        return false;
    }

    public void clearShortcutToTurn(int timestamp, Object source) {
        this.shortcut.clear();
        this.firePropertyChanged(22, timestamp, source);
    }

    public void appendShortcutToTurn(int next, int timestamp, Object source) {
        this.shortcut.append(next);
        this.firePropertyChanged(22, timestamp, source);
    }

    public int[] getPocketToTurnAcross() {
        return this.pocket.getValues();
    }

    public boolean setPocketToTurnAcross(int[] p, int timestamp, Object source) {
        if (this.pocket.updateValues(p, timestamp, source)) {
            this.firePropertyChanged(23, timestamp, source);
            return true;
        }
        return false;
    }

    public void clearPocketToTurnAcross(int timestamp, Object source) {
        this.pocket.clear();
        this.firePropertyChanged(23, timestamp, source);
    }

    public void appendPocketToTurnAcross(int next, int timestamp, Object source) {
        this.pocket.append(next);
        this.firePropertyChanged(23, timestamp, source);
    }

    public int[] getSignalTiming() {
        return this.timing.getValues();
    }

    public boolean setSignalTiming(int[] t, int timestamp, Object source) {
        if (this.timing.updateValues(t, timestamp, source)) {
            this.firePropertyChanged(24, timestamp, source);
            return true;
        }
        return false;
    }

    public void clearSignalTiming(int timestamp, Object source) {
        this.timing.clear();
        this.firePropertyChanged(24, timestamp, source);
    }

    public void appendSignalTiming(int next, int timestamp, Object source) {
        this.timing.append(next);
        this.firePropertyChanged(24, timestamp, source);
    }
}

