/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.log;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import rescuecore.HashMemory;
import rescuecore.InputBuffer;
import rescuecore.Memory;
import rescuecore.commands.Command;
import rescuecore.commands.Commands;
import rescuecore.commands.Update;
import rescuecore.log.Log;

public class LogVersion2
extends Log {
    private Map<Integer, Update> updates = new HashMap<Integer, Update>();
    private Map<Integer, Commands> commands = new HashMap<Integer, Commands>();
    private int maxTimestep = 0;
    private Map<String, String> config = new HashMap<String, String>();
    private Memory memory;
    private int lastTime;

    public LogVersion2(InputBuffer in) throws IOException {
        int size = in.readInt();
        int configEntries = in.readInt();
        for (int i = 0; i < configEntries; ++i) {
            String key = in.readString();
            String value = in.readString();
            this.config.put(key, value);
        }
        Object c = null;
        while (in.available() > 0) {
            Command[] newCommands;
            for (Command next : newCommands = this.readCommands(in)) {
                if (next instanceof Update) {
                    Update u = (Update)next;
                    this.updates.put(u.getTime(), u);
                    this.maxTimestep = Math.max(this.maxTimestep, u.getTime());
                    continue;
                }
                if (next instanceof Commands) {
                    Commands o = (Commands)next;
                    this.commands.put(o.getTime(), o);
                    this.maxTimestep = Math.max(this.maxTimestep, o.getTime());
                    continue;
                }
                System.err.println("Unrecognised command in log: " + next);
            }
        }
        this.getMemory(0);
    }

    @Override
    public int getMaxTimestep() {
        return this.maxTimestep;
    }

    @Override
    public Update getUpdate(int timestep) {
        return this.updates.get(timestep);
    }

    @Override
    public Commands getCommands(int timestep) {
        return this.commands.get(timestep);
    }

    @Override
    public Map<String, String> getConfigValues() {
        return new HashMap<String, String>(this.config);
    }

    @Override
    public Memory getMemory(int timestep) {
        if (this.memory == null || this.lastTime > timestep) {
            this.memory = new HashMemory();
            this.lastTime = -1;
        }
        try {
            for (int currentTime = this.lastTime + 1; currentTime <= timestep && currentTime < this.maxTimestep; ++currentTime) {
                Update update = this.getUpdate(currentTime);
                if (update == null) continue;
                this.memory.update(update);
            }
            this.lastTime = timestep;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.memory;
    }

    private Command[] readCommands(InputBuffer in) {
        int totalSize = in.readInt();
        return in.readCommands();
    }
}

