/*
 * Decompiled with CFR 0.152.
 */
package rescuecore;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import rescuecore.ArrayProperty;
import rescuecore.Handy;
import rescuecore.InputBuffer;
import rescuecore.IntProperty;
import rescuecore.OutputBuffer;
import rescuecore.Property;
import rescuecore.event.PropertyChangedEvent;
import rescuecore.event.PropertyListener;
import rescuecore.objects.AmbulanceCenter;
import rescuecore.objects.AmbulanceTeam;
import rescuecore.objects.Building;
import rescuecore.objects.Car;
import rescuecore.objects.Civilian;
import rescuecore.objects.FireBrigade;
import rescuecore.objects.FireStation;
import rescuecore.objects.Node;
import rescuecore.objects.PoliceForce;
import rescuecore.objects.PoliceOffice;
import rescuecore.objects.Refuge;
import rescuecore.objects.River;
import rescuecore.objects.RiverNode;
import rescuecore.objects.Road;
import rescuecore.objects.World;

public abstract class RescueObject
implements Serializable {
    private transient Collection listeners = new ArrayList();
    protected int id = 0;
    private transient int[] knownProperties = null;
    private transient HashMap annotations = null;

    protected RescueObject() {
    }

    public void addAnnotation(String key, Object annotation) {
        if (this.annotations == null) {
            this.annotations = new HashMap();
        }
        this.annotations.put(key, annotation);
    }

    public Object getAnnotation(String key) {
        if (this.annotations == null) {
            return null;
        }
        return this.annotations.get(key);
    }

    public abstract int getType();

    public int getID() {
        return this.id;
    }

    public void setID(int id) {
        this.id = id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o instanceof RescueObject) {
            return this.id == ((RescueObject)o).id;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyListener(PropertyListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        Collection collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyListener(PropertyListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        Collection collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(l);
        }
    }

    protected String getPropertiesString() {
        StringBuffer result = new StringBuffer();
        int[] known = this.getKnownPropertyTypes();
        for (int i = 0; i < known.length; ++i) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(this.getPropertyAsString(known[i]));
        }
        return result.toString();
    }

    public int[] getKnownPropertyTypes() {
        if (this.knownProperties == null) {
            ArrayList<Integer> c = new ArrayList<Integer>();
            for (int i = 1; i <= 48; ++i) {
                if (!this.propertyExists(i)) continue;
                c.add(new Integer(i));
            }
            Object[] all = c.toArray();
            this.knownProperties = new int[all.length];
            for (int i = 0; i < all.length; ++i) {
                this.knownProperties[i] = (Integer)all[i];
            }
        }
        return this.knownProperties;
    }

    public final boolean propertyExists(int property) {
        return this.getProperty(property) != null;
    }

    public Property getProperty(int property) {
        return null;
    }

    public String getPropertyAsString(int property) {
        Property p = this.getProperty(property);
        if (p == null) {
            return "<unknown>";
        }
        return p.getStringValue();
    }

    public int getLastPropertyUpdate(int property) {
        Property p = this.getProperty(property);
        if (p == null) {
            return -2;
        }
        return p.getLastUpdate();
    }

    public Object getLastPropertyUpdateSource(int property) {
        Property p = this.getProperty(property);
        if (p == null) {
            return null;
        }
        return p.getLastUpdateSource();
    }

    public boolean isPropertyValueKnown(int property) {
        Property p = this.getProperty(property);
        if (p == null) {
            return false;
        }
        return p.isValueKnown();
    }

    public boolean isPropertyValueAssumed(int property) {
        Property p = this.getProperty(property);
        if (p == null) {
            return false;
        }
        return p.isValueAssumed();
    }

    protected boolean setProperty(IntProperty p, int newValue, int timestamp, Object source) {
        if (p.setValue(newValue, timestamp, source)) {
            this.firePropertyChanged(p.getType(), timestamp, source);
            return true;
        }
        return false;
    }

    protected boolean setProperty(ArrayProperty p, int[] newValue, int timestamp, Object source) {
        if (p.setValues(newValue, timestamp, source)) {
            this.firePropertyChanged(p.getType(), timestamp, source);
            return true;
        }
        return false;
    }

    protected boolean updateProperty(IntProperty p, int newValue, int timestamp, Object source) {
        if (p.updateValue(newValue, timestamp, source)) {
            this.firePropertyChanged(p.getType(), timestamp, source);
            return true;
        }
        return false;
    }

    protected boolean updateProperty(ArrayProperty p, int[] newValue, int timestamp, Object source) {
        if (p.updateValues(newValue, timestamp, source)) {
            this.firePropertyChanged(p.getType(), timestamp, source);
            return true;
        }
        return false;
    }

    public String toString() {
        return Handy.getTypeName(this.getType()) + " " + this.id;
    }

    public String toLongString() {
        return Handy.getTypeName(this.getType()) + " " + this.id + " [" + this.getPropertiesString() + "]";
    }

    public final void read(InputBuffer in, int timestamp, Object source) {
        int prop;
        do {
            if ((prop = in.readInt()) == 0) continue;
            int size = in.readInt();
            Property p = this.getProperty(prop);
            if (p != null) {
                if (!p.read(in, timestamp, source)) continue;
                this.firePropertyChanged(prop, timestamp, source);
                continue;
            }
            System.err.println("Got an unknown property (" + prop + ") from the stream");
            in.skip(size);
        } while (prop != 0);
    }

    public final void merge(RescueObject o) {
        int[] known = this.getKnownPropertyTypes();
        for (int i = 0; i < known.length; ++i) {
            Property oldP = this.getProperty(known[i]);
            Property newP = o.getProperty(known[i]);
            if (oldP == null || newP == null || !oldP.merge(newP)) continue;
            this.firePropertyChanged(oldP.getType(), oldP.getLastUpdate(), oldP.getLastUpdateSource());
        }
    }

    public void write(OutputBuffer out) {
        int[] props = this.getKnownPropertyTypes();
        for (int i = 0; i < props.length; ++i) {
            Property p = this.getProperty(props[i]);
            if (p == null || !p.isValueKnown()) continue;
            out.writeInt(p.getType());
            int base = out.markBlock();
            p.write(out);
            out.writeBlockSize(base);
        }
        out.writeInt(0);
    }

    public boolean isBuilding() {
        switch (this.getType()) {
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                return true;
            }
        }
        return false;
    }

    public boolean isOrdinaryBuilding() {
        return this.getType() == 32;
    }

    public boolean isRefuge() {
        return this.getType() == 33;
    }

    public boolean isFireStation() {
        return this.getType() == 34;
    }

    public boolean isPoliceOffice() {
        return this.getType() == 36;
    }

    public boolean isAmbulanceCenter() {
        return this.getType() == 35;
    }

    public boolean isRoad() {
        return this.getType() == 2;
    }

    public boolean isNode() {
        return this.getType() == 4;
    }

    public boolean isHumanoid() {
        switch (this.getType()) {
            case 64: 
            case 66: 
            case 67: 
            case 68: {
                return true;
            }
        }
        return false;
    }

    public boolean isCivilian() {
        return this.getType() == 64;
    }

    public boolean isAmbulanceTeam() {
        return this.getType() == 67;
    }

    public boolean isPoliceForce() {
        return this.getType() == 68;
    }

    public boolean isFireBrigade() {
        return this.getType() == 66;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePropertyChanged(int property, int timestep, Object source) {
        if (this.listeners == null) {
            return;
        }
        PropertyChangedEvent event = new PropertyChangedEvent(this, property, timestep, source);
        Collection collection = this.listeners;
        synchronized (collection) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ((PropertyListener)it.next()).propertyChanged(event);
            }
        }
    }

    public final RescueObject copy() {
        RescueObject result = RescueObject.newObject(this.getType());
        result.merge(this);
        result.setID(this.id);
        return result;
    }

    public static RescueObject newObject(int type) {
        switch (type) {
            case 1: {
                return new World();
            }
            case 64: {
                return new Civilian();
            }
            case 65: {
                return new Car();
            }
            case 66: {
                return new FireBrigade();
            }
            case 67: {
                return new AmbulanceTeam();
            }
            case 68: {
                return new PoliceForce();
            }
            case 2: {
                return new Road();
            }
            case 3: {
                return new River();
            }
            case 4: {
                return new Node();
            }
            case 5: {
                return new RiverNode();
            }
            case 32: {
                return new Building();
            }
            case 33: {
                return new Refuge();
            }
            case 34: {
                return new FireStation();
            }
            case 35: {
                return new AmbulanceCenter();
            }
            case 36: {
                return new PoliceOffice();
            }
        }
        System.out.println("WARNING: Unknown object type: " + type);
        return null;
    }
}

