/*
 * Decompiled with CFR 0.152.
 */
package gis2.scenario;

import gis2.scenario.ScenarioEditor;
import gis2.scenario.ShapeTool;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLShape;

public class PlaceCivilianTool
extends ShapeTool {
    public PlaceCivilianTool(ScenarioEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Place civilian";
    }

    @Override
    protected boolean shouldHighlight(GMLShape shape) {
        return true;
    }

    @Override
    protected void processClick(GMLShape shape) {
        this.editor.getScenario().addCivilian(shape.getID());
        this.editor.setChanged();
        this.editor.updateOverlays();
        this.editor.addEdit(new AddCivilianEdit(shape.getID()));
    }

    private class AddCivilianEdit
    extends AbstractUndoableEdit {
        private int id;

        public AddCivilianEdit(int id) {
            this.id = id;
        }

        @Override
        public void undo() {
            super.undo();
            PlaceCivilianTool.this.editor.getScenario().removeCivilian(this.id);
            PlaceCivilianTool.this.editor.updateOverlays();
        }

        @Override
        public void redo() {
            super.redo();
            PlaceCivilianTool.this.editor.getScenario().addCivilian(this.id);
            PlaceCivilianTool.this.editor.updateOverlays();
        }
    }
}

