/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.Player;
import gui.MainFrame;
import gui.PlayerPanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class ResultPanel
extends JPanel {
    private static String[] col = new String[]{"ID", "\u540d\u524d", "\u65e7\u70b9\u6570", "\u52dd\u6570", "\u8ca0\u6570", "\u65b0\u70b9\u6570\uff08\u5897\u6e1b\uff09"};
    static final JTable resultTable = new JTable(new DefaultTableModel(new String[0][0], col)){

        @Override
        public boolean isCellEditable(int row, int column) {
            return column != 0;
        }
    };
    static final JScrollPane scrollPanel = new JScrollPane(resultTable);
    static final JPanel buttonPanel = new JPanel();
    static final JButton okButton = new JButton("OK");
    static final JButton cancelButton = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");

    public ResultPanel() {
        scrollPanel.setPreferredSize(new Dimension(550, 150));
        this.setLayout(new BoxLayout(this, 1));
        this.add(scrollPanel);
        this.add(buttonPanel);
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (resultTable.getRowCount() > 0) {
                    int ans = JOptionPane.showConfirmDialog(null, "\u30d7\u30ec\u30a4\u30e4\u30fc\u60c5\u5831\u3092\u66f4\u65b0\u3057\u307e\u3059\u304b\uff1f");
                    if (ans == 0) {
                        for (Player player : MainFrame.playerList) {
                            if (!player.isUpdate()) continue;
                            player.setUpdate(false);
                            player.setRate(player.getRate() + player.getVariation());
                            player.setWin(player.getWin() + player.getNewWin());
                            player.setLose(player.getLose() + player.getNewLose());
                            player.setVariation(0);
                            player.setNewWin(0);
                            player.setNewLose(0);
                            PlayerPanel.update();
                            ResultPanel.update();
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "\u5bfe\u5c40\u7d50\u679c\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                }
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (resultTable.getRowCount() > 0) {
                    int ans = JOptionPane.showConfirmDialog(null, "\u7d50\u679c\u30c6\u30fc\u30d6\u30eb\u3092\u30ea\u30bb\u30c3\u30c8\u3057\u307e\u3059\u304b\uff1f");
                    if (ans == 0) {
                        for (Player player : MainFrame.playerList) {
                            if (!player.isUpdate()) continue;
                            player.setUpdate(false);
                            player.setVariation(0);
                            player.setNewWin(0);
                            player.setNewLose(0);
                            PlayerPanel.update();
                            ResultPanel.update();
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "\u5bfe\u5c40\u7d50\u679c\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                }
            }
        });
    }

    private static String[][] getDisplayData() {
        ArrayList<Player> updatePlayerList = new ArrayList<Player>();
        for (Player player : MainFrame.playerList) {
            if (!player.isUpdate()) continue;
            updatePlayerList.add(player);
        }
        String[][] displayData = new String[updatePlayerList.size()][col.length];
        int i = 0;
        while (i < updatePlayerList.size()) {
            Player player = (Player)updatePlayerList.get(i);
            displayData[i][0] = Integer.toString(player.getId());
            displayData[i][1] = player.getName();
            displayData[i][2] = Integer.toString(player.getRate());
            displayData[i][3] = Integer.toString(player.getNewWin());
            displayData[i][4] = Integer.toString(player.getNewLose());
            displayData[i][5] = String.valueOf(Integer.toString(player.getRate() + player.getVariation())) + "(" + Integer.toString(player.getVariation()) + ")";
            ++i;
        }
        return displayData;
    }

    public static void update() {
        resultTable.setModel(new DefaultTableModel(ResultPanel.getDisplayData(), col));
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(resultTable.getModel());
        resultTable.setRowSorter(sorter);
        resultTable.revalidate();
        resultTable.repaint();
    }
}

