<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */
class UpgradeController_115 extends BaseController {

  public function __construct(RaRequest $request, RaSession $session, RaMessage $message, RaResult $result, $controller, $action) {
    parent::__construct($request, $session, $message, $result, $controller, $action);
  }

  public function upgrade() {
    $upgradeSqlDir = UPGRADE_DIR. '1.15'. DIRECTORY_SEPARATOR. 'sql'. DIRECTORY_SEPARATOR;
    $upgradeSqlOldDir = UPGRADE_DIR. '1.15'. DIRECTORY_SEPARATOR. 'sql'. DIRECTORY_SEPARATOR. 'old'. DIRECTORY_SEPARATOR;
    $id = !is_null($this->session->get('login')) ? $this->session->get('login') : Config::SYSTEM_DEFAULT_ID;
    $site = new Site();
    $site->find(array('condition' => array('id = ?', $id)));
    $createYyyyMm = str_replace('-', '', substr($site->getValue('created_on'), 0, 7));
    if (trim($createYyyyMm) == '') $createYyyyMm = '200909';
    $next = 1;
    while(true) {
      $yyyymm = Calendar::getNextMonth($next);
      if ($yyyymm < $createYyyyMm) break;
      $log = new Log(false, $yyyymm);
      $log->loadSql($upgradeSqlDir. 'alter_log.sql', $upgradeSqlOldDir. 'alter_log.sql');
      $log = null;
      $next--;
    }
    return true;
  }

}
?>
