/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.eclipse.quick;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TestingPair {
    private List namingRules = new ArrayList();

    public void addNamingRule(String rule) {
        this.namingRules.add(rule);
    }

    public void clearNamingRules() {
        this.namingRules.clear();
    }

    public String[] getPairClassNames(String className) {
        LinkedHashSet result = new LinkedHashSet();
        className = this.chopInnerClassName(className);
        this.addTestedClassNames(className, result);
        if (result.isEmpty()) {
            this.addTestClassNames(className, result);
        }
        return result.toArray(new String[result.size()]);
    }

    private void addTestedClassNames(String className, Set result) {
        int i = 0;
        while (i < this.namingRules.size()) {
            String testedClassName = this.getTestedClassName(className, (String)this.namingRules.get(i));
            if (testedClassName != null) {
                result.add(testedClassName);
            }
            ++i;
        }
    }

    private String escapeAllChars(String str) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if ("\\${}?+.[]-()><!|^:=*&,".indexOf(c) != -1) {
                buf.append('\\');
            }
            buf.append(c);
            ++i;
        }
        return buf.toString();
    }

    private String getTestedClassName(String className, String namingRule) {
        int index = className.lastIndexOf(46);
        namingRule = this.escapeAllChars(namingRule);
        if (index == -1) {
            namingRule = namingRule.replaceAll("\\\\\\$\\\\\\{package\\\\\\}\\\\\\.", "");
            Pattern p = Pattern.compile(namingRule = namingRule.replaceAll("\\\\\\$\\\\\\{type\\\\\\}", "(\\\\w+)"));
            Matcher m = p.matcher(className);
            if (m.matches()) {
                return m.group(1);
            }
        } else {
            Pattern p = Pattern.compile((namingRule = namingRule.replaceAll("\\\\\\$\\\\\\{package\\\\\\}\\\\\\.", "(?:([\\\\w\\\\.]+)\\\\.)?")).replaceAll("\\\\\\$\\\\\\{type\\\\\\}", "(\\\\w+)"));
            Matcher m = p.matcher(className);
            if (m.matches()) {
                if (m.group(1) == null) {
                    return m.group(2);
                }
                return String.valueOf(m.group(1)) + "." + m.group(2);
            }
        }
        return null;
    }

    private void addTestClassNames(String className, Set result) {
        String packageName;
        String typeName;
        int index = className.lastIndexOf(46);
        if (index != -1) {
            typeName = className.substring(index + 1);
            packageName = className.substring(0, index);
        } else {
            typeName = className;
            packageName = null;
        }
        int i = 0;
        while (i < this.namingRules.size()) {
            result.add(this.getTestClassName(packageName, typeName, (String)this.namingRules.get(i)));
            ++i;
        }
    }

    private String getTestClassName(String packageName, String typeName, String namingRule) {
        String result = new String(namingRule);
        result = packageName != null ? result.replaceAll("\\$\\{package\\}", packageName) : result.replaceAll("\\$\\{package\\}\\.", "");
        return result.replaceAll("\\$\\{type\\}", typeName);
    }

    private String chopInnerClassName(String className) {
        int index = className.indexOf(36);
        if (index == -1) {
            return className;
        }
        return className.substring(0, index);
    }
}

