#ifndef QRK_CAPTURE_SETTINGS_H
#define QRK_CAPTURE_SETTINGS_H

/*!
  \file
  \brief データ取得設定

  \author Satofumi KAMIMURA

  $Id: CaptureSettings.h 783 2009-05-05 08:56:26Z satofumi $
*/

/*!
  \brief Quick Robot Development Kit.
*/
namespace qrk
{
  /*!
    \brief 受信データのタイプ
  */
  typedef enum {
    TypeUnknown,                //!< 不明
    QT,                         //!< 停止コマンドを受信
    GD,                         //!< 逐次データ取得(距離 3 byte 表現)
    GS,                         //!< 逐次データ取得(距離 2 byte 表現)
    MD,                         //!< 自動データ取得(距離 3 byte 表現)
    MS,                         //!< 自動データ取得(距離 2 byte 表現)
    ME,                         //!< M コマンドの応答
    Mx_Reply,                   //!< Mx コマンドの最初の応答メッセージ
    InvalidData,                //!< 受信データのエラー
  } CaptureType;


  /*!
    \brief データ取得設定
  */
  class CaptureSettings
  {
  public:
    CaptureType type;           //!< 受信データの種類
    int error_code;             //!< エラーコード
    long timestamp;             //!< タイムスタンプ [msec]
    int capture_first;          //!< 取得開始インデックス
    int capture_last;           //!< 取得終了インデックス
    int skip_lines;             //!< 間引きライン数
    int skip_frames;            //!< データ取得間隔
    int remain_times;           //!< データ取得の残り回数
    int data_byte;              //!< データバイト数


    CaptureSettings(void)
      : type(TypeUnknown), error_code(-1), timestamp(-1),
        capture_first(-1), capture_last(-1),
        skip_lines(-1), skip_frames(-1), remain_times(-1), data_byte(-1)
    {
    }
  };
}

#endif /* !QRK_CAPTURE_SETTINGS_H */
