/*!
  \example scip_20_ss.cpp

  \brief SS コマンドの実行サンプル

  \author Satofumi KAMIMURA

  $Id: scip_20_ss.cpp 1099 2009-06-30 02:47:18Z satofumi $
*/

#include "SerialDevice.h"
#include "DetectOS.h"
#include "ConnectionUtils.h"
#include <cstdio>

using namespace qrk;


//! main
int main(int argc, char *argv[]) {

  // 適切にポート名を変更すること
#if defined(WINDOWS_OS)
  const char device[] = "COM3";
#elif defined(LINUX_OS)
  //const char device[] = "/dev/ttyUSB0";
  const char device[] = "/dev/ttyACM0";
#else
  const char device[] = "/dev/tty.usbmodem1d11";
#endif

  SerialDevice con;
  if (! con.connect(device, 19200)) {
    printf("SerialDevice::connect: %s\n", con.what());
    exit(1);
  }

  // ボーレートを変更しながら、"SCIP2.0" を発行し、応答を出力する
  long try_baudrate[] = { 115200, 19200, 38400 };
  size_t try_times = sizeof(try_baudrate)/sizeof(try_baudrate[0]);
  for (size_t i = 0; i < try_times; ++i) {

    // ホスト側のボーレートを変更
    printf("set host baudrate: %ld\n", try_baudrate[i]);
    con.setBaudrate(try_baudrate[i]);
    con.flush();

    con.send("SCIP2.0\n", 8);

    // 応答を出力
    enum { LineMax = 64 + 1, Timeout = 200 };
    char buffer[LineMax];
    int n;
    while ((n = readline(&con, buffer, LineMax, Timeout)) > 0) {
      printf("%s\n", buffer);
    }
  }

  return 0;
}
