/*!
  \example get_timestamp.c

  \brief タイムスタンプの取得サンプル

  TM0, TM1, TM2 コマンドを用いて、タイムスタンプを取得する

  \author Satofumi KAMIMURA

  $Id: get_timestamp.c 1194 2009-07-31 13:45:24Z satofumi $
*/

#include "urg_ctrl.h"
#include <stdio.h>
#include <stdlib.h>


static void urg_exit(urg_t *urg, const char *message)
{
  printf("%s: %s\n", message, urg_error(urg));
  urg_disconnect(urg);

#ifdef MSC
  getchar();
#endif
  exit(1);
}


//! main
int main(int argc, char *argv[])
{
  enum {
    CaptureTimes = 10,
  };

  const char device[] = "COM3"; /* Windows での例 */
  //const char device[] = "/dev/ttyACM0"; /* Linux での例 */

  long timestamp = 0;
  int ret = 0;
  int i;

  /* 接続 */
  urg_t urg;
  ret = urg_connect(&urg, device, 115200);
  if (ret < 0) {
    urg_exit(&urg, "urg_connect()");
  }

  /* タイムスタンプモードに遷移し、タイムスタンプを表示する */
  urg_enableTimestampMode(&urg);
  for (i = 0; i < CaptureTimes; ++i) {
    timestamp = urg_currentTimestamp(&urg);
    printf("%02d: timestamp: %ld [msec]\n", i, timestamp);
  }
  urg_disableTimestampMode(&urg);

#ifdef MSC
  getchar();
#endif

  return 0;
}
