#ifndef QRK_FINED_FILES_H
#define QRK_FINED_FILES_H

/*!
  \file
  \brief ディレクトリ以下のファイル探索を行う

  \author Satofumi KAMIMURA

  $Id: findFiles.h 783 2009-05-05 08:56:26Z satofumi $
*/

#include <boost/xpressive/xpressive.hpp>
#include <vector>


namespace qrk
{
  /*!
    ディレクトリ以下のファイル探索を行う

    \param[out] files 見付かったファイル
    \param[in] root_path 探索のルートディレクトリ
    \param[in] pattern ファイルの検索パターン

    \return 見付かったファイル数
  */
  extern size_t findFiles(std::vector<std::string>& files,
                          const char* root_path,
                          const boost::xpressive::sregex pattern);
}

#endif /* !QRK_FINED_FILES_H */
