/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.data;

import java.util.Vector;
import jp.sourceforge.qrcode.ecc.BCH15_5;
import jp.sourceforge.qrcode.geom.Point;
import jp.sourceforge.qrcode.pattern.LogicalSeed;

public class QRCodeSymbol {
    int version;
    int errorCollectionLevel;
    int maskPattern;
    int dataCapacity;
    boolean[][] moduleMatrix;
    int width;
    int height;
    Point[][] alignmentPattern;
    final int[][] numErrorCollectionCode = new int[][]{{7, 10, 13, 17}, {10, 16, 22, 28}, {15, 26, 36, 44}, {20, 36, 52, 64}, {26, 48, 72, 88}, {36, 64, 96, 112}, {40, 72, 108, 130}, {48, 88, 132, 156}, {60, 110, 160, 192}, {72, 130, 192, 224}, {80, 150, 224, 264}, {96, 176, 260, 308}, {104, 198, 288, 352}, {120, 216, 320, 384}, {132, 240, 360, 432}, {144, 280, 408, 480}, {168, 308, 448, 532}, {180, 338, 504, 588}, {196, 364, 546, 650}, {224, 416, 600, 700}, {224, 442, 644, 750}, {252, 476, 690, 816}, {270, 504, 750, 900}, {300, 560, 810, 960}, {312, 588, 870, 1050}, {336, 644, 952, 1110}, {360, 700, 1020, 1200}, {390, 728, 1050, 1260}, {420, 784, 1140, 1350}, {450, 812, 1200, 1440}, {480, 868, 1290, 1530}, {510, 924, 1350, 1620}, {540, 980, 1440, 1710}, {570, 1036, 1530, 1800}, {570, 1064, 1590, 1890}, {600, 1120, 1680, 1980}, {630, 1204, 1770, 2100}, {660, 1260, 1860, 2220}, {720, 1316, 1950, 2310}, {750, 1372, 2040, 2430}};
    final int[][] numRSBlocks = new int[][]{{1, 1, 1, 1}, {1, 1, 1, 1}, {1, 1, 2, 2}, {1, 2, 2, 4}, {1, 2, 4, 4}, {2, 4, 4, 4}, {2, 4, 6, 5}, {2, 4, 6, 6}, {2, 5, 8, 8}, {4, 5, 8, 8}, {4, 5, 8, 11}, {4, 8, 10, 11}, {4, 9, 12, 16}, {4, 9, 16, 16}, {6, 10, 12, 18}, {6, 10, 17, 16}, {6, 11, 16, 19}, {6, 13, 18, 21}, {7, 14, 21, 25}, {8, 16, 20, 25}, {8, 17, 23, 25}, {9, 17, 23, 34}, {9, 18, 25, 30}, {10, 20, 27, 32}, {12, 21, 29, 35}, {12, 23, 34, 37}, {12, 25, 34, 40}, {13, 26, 35, 42}, {14, 28, 38, 45}, {15, 29, 40, 48}, {16, 31, 43, 51}, {17, 33, 45, 54}, {18, 35, 48, 57}, {19, 37, 51, 60}, {19, 38, 53, 63}, {20, 40, 56, 66}, {21, 43, 59, 70}, {22, 45, 62, 74}, {24, 47, 65, 77}, {25, 49, 68, 81}};

    public boolean getElement(int n, int n2) {
        return this.moduleMatrix[n][n2];
    }

    public int getNumErrorCollectionCode() {
        return this.numErrorCollectionCode[this.version - 1][this.errorCollectionLevel];
    }

    public int getNumRSBlocks() {
        return this.numRSBlocks[this.version - 1][this.errorCollectionLevel];
    }

    public QRCodeSymbol(boolean[][] blArray) {
        this.moduleMatrix = blArray;
        this.width = blArray.length;
        this.height = blArray[0].length;
        this.initialize();
    }

    void initialize() {
        this.version = (this.width - 17) / 4;
        Point[][] pointArray = new Point[1][1];
        int[] nArray = new int[1];
        if (this.version >= 2 && this.version <= 40) {
            nArray = LogicalSeed.getSeed(this.version);
            pointArray = new Point[nArray.length][nArray.length];
        }
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                pointArray[j][i] = new Point(nArray[j], nArray[i]);
            }
        }
        this.alignmentPattern = pointArray;
        this.dataCapacity = this.calcDataCapacity();
        boolean[] blArray = this.readFormatInformation();
        this.decodeFormatInformation(blArray);
        this.unmask();
    }

    public int getVersion() {
        return this.version;
    }

    public String getVersionReference() {
        char[] cArray = new char[]{'L', 'M', 'Q', 'H'};
        return Integer.toString(this.version) + "-" + cArray[this.errorCollectionLevel];
    }

    public Point[][] getAlignmentPattern() {
        return this.alignmentPattern;
    }

    boolean[] readFormatInformation() {
        int n;
        boolean[] blArray = new boolean[15];
        for (n = 0; n <= 5; ++n) {
            blArray[n] = this.getElement(8, n);
        }
        blArray[6] = this.getElement(8, 7);
        blArray[7] = this.getElement(8, 8);
        blArray[8] = this.getElement(7, 8);
        for (n = 9; n <= 14; ++n) {
            blArray[n] = this.getElement(14 - n, 8);
        }
        n = 21522;
        for (int i = 0; i <= 14; ++i) {
            boolean bl = false;
            bl = (n >>> i & 1) == 1;
            blArray[i] = blArray[i] != bl;
        }
        BCH15_5 bCH15_5 = new BCH15_5(blArray);
        boolean[] blArray2 = bCH15_5.correct();
        boolean[] blArray3 = new boolean[5];
        for (int i = 0; i < 5; ++i) {
            blArray3[i] = blArray2[10 + i];
        }
        return blArray3;
    }

    void unmask() {
        boolean[][] blArray = this.generateMaskPattern();
        int n = this.getWidth();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!blArray[j][i]) continue;
                this.reverseElement(j, i);
            }
        }
    }

    boolean[][] generateMaskPattern() {
        int n = this.getMaskPatternReferer();
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        boolean[][] blArray = new boolean[n2][n3];
        for (int i = 0; i < n3; ++i) {
            block11: for (int j = 0; j < n2; ++j) {
                if (this.isInFunctionPattern(j, i)) continue;
                switch (n) {
                    case 0: {
                        if ((i + j) % 2 != 0) continue block11;
                        blArray[j][i] = true;
                        continue block11;
                    }
                    case 1: {
                        if (i % 2 != 0) continue block11;
                        blArray[j][i] = true;
                        continue block11;
                    }
                    case 2: {
                        if (j % 3 != 0) continue block11;
                        blArray[j][i] = true;
                        continue block11;
                    }
                    case 3: {
                        if ((i + j) % 3 != 0) continue block11;
                        blArray[j][i] = true;
                        continue block11;
                    }
                    case 4: {
                        if ((i / 2 + j / 3) % 2 != 0) continue block11;
                        blArray[j][i] = true;
                        continue block11;
                    }
                    case 5: {
                        if (i * j % 2 + i * j % 3 != 0) continue block11;
                        blArray[j][i] = true;
                        continue block11;
                    }
                    case 6: {
                        if ((i * j % 2 + i * j % 3) % 2 != 0) continue block11;
                        blArray[j][i] = true;
                        continue block11;
                    }
                    case 7: {
                        if ((i * j % 3 + (i + j) % 2) % 2 != 0) continue block11;
                        blArray[j][i] = true;
                    }
                }
            }
        }
        return blArray;
    }

    private int calcDataCapacity() {
        int n = 0;
        int n2 = 0;
        int n3 = this.getVersion();
        n2 = n3 <= 6 ? 31 : 67;
        int n4 = n3 / 7 + 2;
        int n5 = n3 == 1 ? 192 : 192 + (n4 * n4 - 3) * 25;
        n = n5 + 8 * n3 + 2 - (n4 - 2) * 10;
        int n6 = (this.width * this.width - n - n2) / 8;
        return n6;
    }

    public int getDataCapacity() {
        return this.dataCapacity;
    }

    void decodeFormatInformation(boolean[] blArray) {
        this.errorCollectionLevel = !blArray[4] ? (blArray[3] ? 0 : 1) : (blArray[3] ? 2 : 3);
        for (int i = 2; i >= 0; --i) {
            if (!blArray[i]) continue;
            this.maskPattern += 1 << i;
        }
    }

    public int getErrorCollectionLevel() {
        return this.errorCollectionLevel;
    }

    public int getMaskPatternReferer() {
        return this.maskPattern;
    }

    public String getMaskPatternRefererAsString() {
        String string = Integer.toString(this.getMaskPatternReferer(), 2);
        int n = string.length();
        for (int i = 0; i < 3 - n; ++i) {
            string = "0" + string;
        }
        return string;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int[] getBlocks() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = n - 1;
        int n4 = n2 - 1;
        Vector<Boolean> vector = new Vector<Boolean>();
        Vector<Integer> vector2 = new Vector<Integer>();
        int n5 = 0;
        int n6 = 7;
        int n7 = 0;
        boolean bl = true;
        do {
            vector.addElement(new Boolean(this.getElement(n3, n4)));
            if (this.getElement(n3, n4)) {
                n5 += 1 << n6;
            }
            if (--n6 == -1) {
                vector2.addElement(new Integer(n5));
                n6 = 7;
                n5 = 0;
            }
            do {
                if (bl) {
                    if ((n3 + n7) % 2 == 0) {
                        --n3;
                        continue;
                    }
                    if (n4 > 0) {
                        ++n3;
                        --n4;
                        continue;
                    }
                    if (--n3 == 6) {
                        --n3;
                        n7 = 1;
                    }
                    bl = false;
                    continue;
                }
                if ((n3 + n7) % 2 == 0) {
                    --n3;
                    continue;
                }
                if (n4 < n2 - 1) {
                    ++n3;
                    ++n4;
                    continue;
                }
                if (--n3 == 6) {
                    --n3;
                    n7 = 1;
                }
                bl = true;
            } while (this.isInFunctionPattern(n3, n4));
        } while (n3 != -1);
        int[] nArray = new int[vector2.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            Integer n8 = (Integer)vector2.elementAt(i);
            nArray[i] = n8;
        }
        return nArray;
    }

    public void reverseElement(int n, int n2) {
        this.moduleMatrix[n][n2] = !this.moduleMatrix[n][n2];
    }

    public boolean isInFunctionPattern(int n, int n2) {
        if (n < 9 && n2 < 9) {
            return true;
        }
        if (n > this.getWidth() - 9 && n2 < 9) {
            return true;
        }
        if (n < 9 && n2 > this.getHeight() - 9) {
            return true;
        }
        if (this.version >= 7) {
            if (n > this.getWidth() - 12 && n2 < 6) {
                return true;
            }
            if (n < 6 && n2 > this.getHeight() - 12) {
                return true;
            }
        }
        if (n == 6 || n2 == 6) {
            return true;
        }
        Point[][] pointArray = this.getAlignmentPattern();
        int n3 = pointArray.length;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n3; ++j) {
                if (j == 0 && i == 0 || j == n3 - 1 && i == 0 || j == 0 && i == n3 - 1 || Math.abs(pointArray[j][i].getX() - n) >= 3 || Math.abs(pointArray[j][i].getY() - n2) >= 3) continue;
                return true;
            }
        }
        return false;
    }
}

