/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.reedsolomon;

import java.util.Arrays;

public final class Galois {
    public static final int POLYNOMIAL = 29;
    private static final Galois instance = new Galois();
    private int[] expTbl = new int[510];
    private int[] logTbl = new int[256];

    private Galois() {
        this.initGaloisTable();
    }

    public static Galois getInstance() {
        return instance;
    }

    private void initGaloisTable() {
        int n = 1;
        for (int i = 0; i < 255; ++i) {
            int n2 = n;
            this.expTbl[255 + i] = n2;
            this.expTbl[i] = n2;
            this.logTbl[n] = i;
            if (((n <<= 1) & 0x100) == 0) continue;
            n = (n ^ 0x1D) & 0xFF;
        }
    }

    public int toExp(int n) {
        return this.expTbl[n];
    }

    public int toLog(int n) {
        return this.logTbl[n];
    }

    public int toPos(int n, int n2) {
        return n - 1 - this.logTbl[n2];
    }

    public int mul(int n, int n2) {
        return n == 0 || n2 == 0 ? 0 : this.expTbl[this.logTbl[n] + this.logTbl[n2]];
    }

    public int mulExp(int n, int n2) {
        return n == 0 ? 0 : this.expTbl[this.logTbl[n] + n2];
    }

    public int div(int n, int n2) {
        return n == 0 ? 0 : this.expTbl[this.logTbl[n] - this.logTbl[n2] + 255];
    }

    public int divExp(int n, int n2) {
        return n == 0 ? 0 : this.expTbl[this.logTbl[n] - n2 + 255];
    }

    public int inv(int n) {
        return this.expTbl[255 - this.logTbl[n]];
    }

    public void mulPoly(int[] nArray, int[] nArray2, int[] nArray3) {
        Arrays.fill(nArray, 0);
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] == 0) continue;
            int n = this.logTbl[nArray2[i]];
            int n2 = Math.min(nArray3.length, nArray.length - i);
            for (int j = 0; j < n2; ++j) {
                if (nArray3[j] == 0) continue;
                int n3 = i + j;
                nArray[n3] = nArray[n3] ^ this.expTbl[n + this.logTbl[nArray3[j]]];
            }
        }
    }

    public boolean calcSyndrome(int[] nArray, int n, int[] nArray2) {
        int n2 = 0;
        for (int i = 0; i < nArray2.length; ++i) {
            int n3 = 0;
            for (int j = 0; j < n; ++j) {
                n3 = nArray[j] ^ (n3 == 0 ? 0 : this.expTbl[this.logTbl[n3] + i]);
            }
            nArray2[i] = n3;
            n2 |= n3;
        }
        return n2 == 0;
    }
}

