/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.reader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import jp.sourceforge.qrcode.QRCodeDecoder;
import jp.sourceforge.qrcode.exception.InvalidDataBlockException;
import jp.sourceforge.qrcode.util.DebugCanvas;

public class QRCodeDataBlockReader {
    int[] blocks;
    int dataLengthMode;
    int blockPointer = 0;
    int bitPointer = 7;
    int dataLength = 0;
    int numErrorCorrectionCode;
    DebugCanvas canvas;
    static final int MODE_NUMBER = 1;
    static final int MODE_ROMAN_AND_NUMBER = 2;
    static final int MODE_8BIT_BYTE = 4;
    static final int MODE_KANJI = 8;
    final int[][] sizeOfDataLengthInfo = new int[][]{{10, 9, 8, 8}, {12, 11, 16, 10}, {14, 13, 16, 12}};

    public QRCodeDataBlockReader(int[] nArray, int n, int n2) {
        this.blocks = nArray;
        this.numErrorCorrectionCode = n2;
        if (n <= 9) {
            this.dataLengthMode = 0;
        } else if (n >= 10 && n <= 26) {
            this.dataLengthMode = 1;
        } else if (n >= 27 && n <= 40) {
            this.dataLengthMode = 2;
        }
        this.canvas = QRCodeDecoder.getCanvas();
    }

    int getNextBits(int n) throws ArrayIndexOutOfBoundsException {
        int n2 = 0;
        if (n < this.bitPointer + 1) {
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                n3 += 1 << i;
            }
            n2 = (this.blocks[this.blockPointer] & (n3 <<= this.bitPointer - n + 1)) >> this.bitPointer - n + 1;
            this.bitPointer -= n;
            return n2;
        }
        if (n < this.bitPointer + 1 + 8) {
            int n4 = 0;
            for (int i = 0; i < this.bitPointer + 1; ++i) {
                n4 += 1 << i;
            }
            n2 = (this.blocks[this.blockPointer] & n4) << n - (this.bitPointer + 1);
            ++this.blockPointer;
            n2 += this.blocks[this.blockPointer] >> 8 - (n - (this.bitPointer + 1));
            this.bitPointer -= n % 8;
            if (this.bitPointer < 0) {
                this.bitPointer = 8 + this.bitPointer;
            }
            return n2;
        }
        if (n < this.bitPointer + 1 + 16) {
            int n5;
            int n6;
            int n7 = 0;
            int n8 = 0;
            for (n6 = 0; n6 < this.bitPointer + 1; ++n6) {
                n7 += 1 << n6;
            }
            n6 = (this.blocks[this.blockPointer] & n7) << n - (this.bitPointer + 1);
            ++this.blockPointer;
            int n9 = this.blocks[this.blockPointer] << n - (this.bitPointer + 1 + 8);
            ++this.blockPointer;
            for (n5 = 0; n5 < n - (this.bitPointer + 1 + 8); ++n5) {
                n8 += 1 << n5;
            }
            n5 = (this.blocks[this.blockPointer] & (n8 <<= 8 - (n - (this.bitPointer + 1 + 8)))) >> 8 - (n - (this.bitPointer + 1 + 8));
            n2 = n6 + n9 + n5;
            this.bitPointer -= (n - 8) % 8;
            if (this.bitPointer < 0) {
                this.bitPointer = 8 + this.bitPointer;
            }
            return n2;
        }
        System.out.println("ERROR!");
        return 0;
    }

    int getNextMode() throws ArrayIndexOutOfBoundsException {
        if (this.blockPointer > this.blocks.length - this.numErrorCorrectionCode - 2) {
            return 0;
        }
        return this.getNextBits(4);
    }

    int guessMode(int n) {
        switch (n) {
            case 3: {
                return 1;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 4;
            }
            case 9: {
                return 8;
            }
            case 10: {
                return 8;
            }
            case 11: {
                return 8;
            }
            case 12: {
                return 4;
            }
            case 13: {
                return 4;
            }
            case 14: {
                return 4;
            }
            case 15: {
                return 4;
            }
        }
        return 8;
    }

    int getDataLength(int n) throws ArrayIndexOutOfBoundsException {
        int n2 = 0;
        while (n >> n2 != 1) {
            ++n2;
        }
        return this.getNextBits(this.sizeOfDataLengthInfo[this.dataLengthMode][n2]);
    }

    public byte[] getDataByte() throws InvalidDataBlockException {
        this.canvas.println("Reading data blocks.");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            while (true) {
                int n;
                if ((n = this.getNextMode()) == 0) {
                    if (byteArrayOutputStream.size() <= 0) {
                        throw new InvalidDataBlockException("Empty data block");
                    }
                    break;
                }
                if (n != 1 && n != 2 && n != 4 && n != 8) {
                    throw new InvalidDataBlockException("Invalid mode: " + n + " in (block:" + this.blockPointer + " bit:" + this.bitPointer + ")");
                }
                this.dataLength = this.getDataLength(n);
                if (this.dataLength < 1) {
                    throw new InvalidDataBlockException("Invalid data length: " + this.dataLength);
                }
                switch (n) {
                    case 1: {
                        byteArrayOutputStream.write(this.getFigureString(this.dataLength).getBytes());
                        break;
                    }
                    case 2: {
                        byteArrayOutputStream.write(this.getRomanAndFigureString(this.dataLength).getBytes());
                        break;
                    }
                    case 4: {
                        byteArrayOutputStream.write(this.get8bitByteArray(this.dataLength));
                        break;
                    }
                    case 8: {
                        byteArrayOutputStream.write(this.getKanjiString(this.dataLength).getBytes());
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new InvalidDataBlockException("Data Block Error in (block:" + this.blockPointer + " bit:" + this.bitPointer + ")");
        }
        catch (IOException iOException) {
            throw new InvalidDataBlockException(iOException.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String getDataString() throws ArrayIndexOutOfBoundsException {
        this.canvas.println("Reading data blocks...");
        String string = "";
        while (true) {
            int n = this.getNextMode();
            this.canvas.println("mode: " + n);
            if (n == 0) break;
            if (n == 1 || n == 2 || n == 4 || n != 8) {
                // empty if block
            }
            this.dataLength = this.getDataLength(n);
            this.canvas.println(Integer.toString(this.blocks[this.blockPointer]));
            System.out.println("length: " + this.dataLength);
            switch (n) {
                case 1: {
                    string = string + this.getFigureString(this.dataLength);
                    break;
                }
                case 2: {
                    string = string + this.getRomanAndFigureString(this.dataLength);
                    break;
                }
                case 4: {
                    string = string + this.get8bitByteString(this.dataLength);
                    break;
                }
                case 8: {
                    string = string + this.getKanjiString(this.dataLength);
                }
            }
        }
        System.out.println("");
        return string;
    }

    String getFigureString(int n) throws ArrayIndexOutOfBoundsException {
        int n2 = n;
        int n3 = 0;
        String string = "";
        do {
            if (n2 >= 3) {
                n3 = this.getNextBits(10);
                if (n3 < 100) {
                    string = string + "0";
                }
                if (n3 < 10) {
                    string = string + "0";
                }
                n2 -= 3;
            } else if (n2 == 2) {
                n3 = this.getNextBits(7);
                if (n3 < 10) {
                    string = string + "0";
                }
                n2 -= 2;
            } else if (n2 == 1) {
                n3 = this.getNextBits(4);
                --n2;
            }
            string = string + Integer.toString(n3);
        } while (n2 > 0);
        return string;
    }

    String getRomanAndFigureString(int n) throws ArrayIndexOutOfBoundsException {
        int n2 = n;
        int n3 = 0;
        String string = "";
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', ' ', '$', '%', '*', '+', '-', '.', '/', ':'};
        do {
            if (n2 > 1) {
                n3 = this.getNextBits(11);
                int n4 = n3 / 45;
                int n5 = n3 % 45;
                string = string + String.valueOf(cArray[n4]);
                string = string + String.valueOf(cArray[n5]);
                n2 -= 2;
                continue;
            }
            if (n2 != 1) continue;
            n3 = this.getNextBits(6);
            string = string + String.valueOf(cArray[n3]);
            --n2;
        } while (n2 > 0);
        return string;
    }

    public byte[] get8bitByteArray(int n) throws ArrayIndexOutOfBoundsException {
        int n2 = n;
        int n3 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        do {
            n3 = this.getNextBits(8);
            byteArrayOutputStream.write((byte)n3);
        } while (--n2 > 0);
        return byteArrayOutputStream.toByteArray();
    }

    String get8bitByteString(int n) throws ArrayIndexOutOfBoundsException {
        int n2 = n;
        int n3 = 0;
        String string = "";
        do {
            n3 = this.getNextBits(8);
            string = string + (char)n3;
        } while (--n2 > 0);
        return string;
    }

    String getKanjiString(int n) throws ArrayIndexOutOfBoundsException {
        int n2 = n;
        int n3 = 0;
        String string = "";
        do {
            n3 = this.getNextBits(13);
            int n4 = n3 % 192;
            int n5 = n3 / 192;
            int n6 = (n5 << 8) + n4;
            int n7 = 0;
            n7 = n6 + 33088 <= 40956 ? n6 + 33088 : n6 + 49472;
            byte[] byArray = new byte[]{(byte)(n7 >> 8), (byte)(n7 & 0xFF)};
            try {
                string = string + new String(byArray, "Shift_JIS");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        } while (--n2 > 0);
        return string;
    }
}

