/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.codec.reader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import jp.sourceforge.qrcode.codec.QRCodeDecoder;
import jp.sourceforge.qrcode.codec.util.DebugCanvas;

public class QRCodeDataBlockReader {
    int[] blocks;
    int dataLengthMode;
    int blockPointer = 0;
    int bitPointer = 7;
    int dataLength = 0;
    DebugCanvas canvas;
    final int MODE_NUMBER;
    final int MODE_ROMAN_AND_NUMBER;
    final int MODE_8BIT_BYTE;
    final int MODE_KANJI;
    final int[][] sizeOfDataLengthInfo = new int[][]{{10, 9, 8, 8}, {12, 11, 16, 10}, {14, 13, 16, 12}};

    public QRCodeDataBlockReader(int[] blocks, int version) {
        this.MODE_NUMBER = 1;
        this.MODE_ROMAN_AND_NUMBER = 2;
        this.MODE_8BIT_BYTE = 4;
        this.MODE_KANJI = 8;
        this.blocks = blocks;
        if (version <= 9) {
            this.dataLengthMode = 0;
        } else if (version >= 10 && version <= 26) {
            this.dataLengthMode = 1;
        } else if (version >= 27 && version <= 40) {
            this.dataLengthMode = 2;
        }
        this.canvas = QRCodeDecoder.getCanvas();
    }

    int getNextBits(int numBits) throws ArrayIndexOutOfBoundsException {
        if (numBits < this.bitPointer + 1) {
            int mask = 0;
            int i = 0;
            while (i < numBits) {
                mask += 1 << i;
                ++i;
            }
            int bits = (this.blocks[this.blockPointer] & (mask <<= this.bitPointer - numBits + 1)) >> this.bitPointer - numBits + 1;
            this.bitPointer -= numBits;
            return bits;
        }
        if (numBits < this.bitPointer + 1 + 8) {
            int mask1 = 0;
            int i = 0;
            while (i < this.bitPointer + 1) {
                mask1 += 1 << i;
                ++i;
            }
            int bits = (this.blocks[this.blockPointer] & mask1) << numBits - (this.bitPointer + 1);
            ++this.blockPointer;
            bits += this.blocks[this.blockPointer] >> 8 - (numBits - (this.bitPointer + 1));
            this.bitPointer -= numBits % 8;
            if (this.bitPointer < 0) {
                this.bitPointer += 8;
            }
            return bits;
        }
        if (numBits < this.bitPointer + 1 + 16) {
            int mask1 = 0;
            int mask3 = 0;
            int i = 0;
            while (i < this.bitPointer + 1) {
                mask1 += 1 << i;
                ++i;
            }
            int bitsFirstBlock = (this.blocks[this.blockPointer] & mask1) << numBits - (this.bitPointer + 1);
            ++this.blockPointer;
            int bitsSecondBlock = this.blocks[this.blockPointer] << numBits - (this.bitPointer + 1 + 8);
            ++this.blockPointer;
            int i2 = 0;
            while (i2 < numBits - (this.bitPointer + 1 + 8)) {
                mask3 += 1 << i2;
                ++i2;
            }
            int bitsThirdBlock = (this.blocks[this.blockPointer] & (mask3 <<= 8 - (numBits - (this.bitPointer + 1 + 8)))) >> 8 - (numBits - (this.bitPointer + 1 + 8));
            int bits = bitsFirstBlock + bitsSecondBlock + bitsThirdBlock;
            this.bitPointer -= (numBits - 8) % 8;
            if (this.bitPointer < 0) {
                this.bitPointer += 8;
            }
            return bits;
        }
        System.out.println("ERROR!");
        return 0;
    }

    int getNextMode() throws ArrayIndexOutOfBoundsException {
        return this.getNextBits(4);
    }

    int guessMode(int mode) {
        if (mode == 3) {
            return 2;
        }
        return 8;
    }

    int getDataLength(int modeIndicator) throws ArrayIndexOutOfBoundsException {
        int index = 0;
        while (modeIndicator >> index != 1) {
            ++index;
        }
        return this.getNextBits(this.sizeOfDataLengthInfo[this.dataLengthMode][index]);
    }

    public byte[] getDataByte() throws ArrayIndexOutOfBoundsException, IOException {
        int mode;
        this.canvas.println("Reading data blocks.");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while ((mode = this.getNextMode()) != 0) {
            if (mode == 1 || mode == 2 || mode == 4 || mode != 8) {
                // empty if block
            }
            this.dataLength = this.getDataLength(mode);
            switch (mode) {
                case 1: {
                    output.write(this.getFigureString(this.dataLength).getBytes());
                    break;
                }
                case 2: {
                    output.write(this.getRomanAndFigureString(this.dataLength).getBytes());
                    break;
                }
                case 4: {
                    output.write(this.get8bitByteArray(this.dataLength));
                    break;
                }
                case 8: {
                    output.write(this.getKanjiString(this.dataLength).getBytes());
                }
            }
        }
        return output.toByteArray();
    }

    public String getDataString() throws ArrayIndexOutOfBoundsException {
        this.canvas.println("Reading data blocks...");
        String dataString = "";
        while (true) {
            int mode = this.getNextMode();
            this.canvas.println("mode: " + mode);
            if (mode == 0) break;
            if (mode == 1 || mode == 2 || mode != 4) {
                // empty if block
            }
            this.dataLength = this.getDataLength(mode);
            this.canvas.println(Integer.toString(this.blocks[this.blockPointer]));
            System.out.println("length: " + this.dataLength);
            switch (mode) {
                case 1: {
                    dataString = String.valueOf(dataString) + this.getFigureString(this.dataLength);
                    break;
                }
                case 2: {
                    dataString = String.valueOf(dataString) + this.getRomanAndFigureString(this.dataLength);
                    break;
                }
                case 4: {
                    dataString = String.valueOf(dataString) + this.get8bitByteString(this.dataLength);
                    break;
                }
                case 8: {
                    dataString = String.valueOf(dataString) + this.getKanjiString(this.dataLength);
                }
            }
        }
        System.out.println("");
        return dataString;
    }

    String getFigureString(int dataLength) throws ArrayIndexOutOfBoundsException {
        int length = dataLength;
        int intData = 0;
        String strData = "";
        do {
            if (length >= 3) {
                intData = this.getNextBits(10);
                if (intData < 100) {
                    strData = String.valueOf(strData) + "0";
                }
                if (intData < 10) {
                    strData = String.valueOf(strData) + "0";
                }
                length -= 3;
            } else if (length == 2) {
                intData = this.getNextBits(7);
                if (intData < 10) {
                    strData = String.valueOf(strData) + "0";
                }
                length -= 2;
            } else if (length == 1) {
                intData = this.getNextBits(4);
                --length;
            }
            strData = String.valueOf(strData) + Integer.toString(intData);
        } while (length > 0);
        return strData;
    }

    String getRomanAndFigureString(int dataLength) throws ArrayIndexOutOfBoundsException {
        int length = dataLength;
        int intData = 0;
        String strData = "";
        char[] tableRomanAndFigure = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', ' ', '$', '%', '*', '+', '-', '.', '/', ':'};
        do {
            if (length > 1) {
                intData = this.getNextBits(11);
                int firstLetter = intData / 45;
                int secondLetter = intData % 45;
                strData = String.valueOf(strData) + String.valueOf(tableRomanAndFigure[firstLetter]);
                strData = String.valueOf(strData) + String.valueOf(tableRomanAndFigure[secondLetter]);
                length -= 2;
                continue;
            }
            if (length != 1) continue;
            intData = this.getNextBits(6);
            strData = String.valueOf(strData) + String.valueOf(tableRomanAndFigure[intData]);
            --length;
        } while (length > 0);
        return strData;
    }

    public byte[] get8bitByteArray(int dataLength) throws ArrayIndexOutOfBoundsException {
        int length = dataLength;
        int intData = 0;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        do {
            intData = this.getNextBits(8);
            output.write((byte)intData);
        } while (--length > 0);
        return output.toByteArray();
    }

    String get8bitByteString(int dataLength) throws ArrayIndexOutOfBoundsException {
        int length = dataLength;
        int intData = 0;
        String strData = "";
        do {
            intData = this.getNextBits(8);
            strData = String.valueOf(strData) + (char)intData;
        } while (--length > 0);
        return strData;
    }

    String getKanjiString(int dataLength) throws ArrayIndexOutOfBoundsException {
        int length = dataLength;
        int intData = 0;
        String unicodeString = "";
        do {
            intData = this.getNextBits(13);
            int lowerByte = intData % 192;
            int higherByte = intData / 192;
            int tempWord = (higherByte << 8) + lowerByte;
            int shiftjisWord = 0;
            shiftjisWord = tempWord + 33088 <= 40956 ? tempWord + 33088 : tempWord + 49472;
            byte[] tempByte = new byte[]{(byte)(shiftjisWord >> 8), (byte)(shiftjisWord & 0xFF)};
            unicodeString = String.valueOf(unicodeString) + new String(tempByte);
        } while (--length > 0);
        return unicodeString;
    }
}

