/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.CameraCanvas;
import example.DecodedTextBox;
import example.DisplayCanvas;
import example.J2MEImage;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import jp.sourceforge.qrcode.codec.QRCodeDecoder;
import jp.sourceforge.qrcode.codec.exception.DecodingFailedException;

public class QRCodeDecoderMIDletExample
extends MIDlet {
    private CameraCanvas cameraCanvas = null;
    private DisplayCanvas displayCanvas = null;
    private DecodedTextBox decodedTextBox = null;

    public void startApp() {
        Displayable current = Display.getDisplay((MIDlet)this).getCurrent();
        if (current == null) {
            this.cameraCanvas = new CameraCanvas(this);
            this.displayCanvas = new DisplayCanvas(this);
            this.decodedTextBox = new DecodedTextBox(this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.cameraCanvas);
            this.cameraCanvas.start();
        } else {
            if (current == this.cameraCanvas) {
                this.cameraCanvas.start();
            }
            Display.getDisplay((MIDlet)this).setCurrent(current);
        }
    }

    public void pauseApp() {
        if (Display.getDisplay((MIDlet)this).getCurrent() == this.cameraCanvas) {
            this.cameraCanvas.stop();
        }
    }

    public void destroyApp(boolean b) {
        if (Display.getDisplay((MIDlet)this).getCurrent() == this.cameraCanvas) {
            this.cameraCanvas.stop();
        }
    }

    private void exitRequested() {
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    void cameraCanvasExit() {
        this.exitRequested();
    }

    void cameraCanvasCaptured(byte[] pngData) {
        this.cameraCanvas.stop();
        this.displayCanvas.setImage(pngData);
        QRCodeDecoder.setCanvas(this.displayCanvas);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.displayCanvas);
        QRCodeDecoder decoder = new QRCodeDecoder();
        Image image = Image.createImage((byte[])pngData, (int)0, (int)pngData.length);
        try {
            this.decodedTextBox.setDecodedString(new String(decoder.decode(new J2MEImage(image))));
        }
        catch (DecodingFailedException dfe) {
            this.displayCanvas.println("Decoding failed");
            this.displayCanvas.println("(" + dfe.getMessage() + ")");
            return;
        }
        this.displayCanvas.addViewDecodedStringCommand();
    }

    void displayCanvasBack() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.cameraCanvas);
        this.cameraCanvas.start();
    }

    void decodedTextBoxBack() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.displayCanvas);
    }

    void toDecodedTextBox() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.decodedTextBox);
    }
}

