/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.codec.util;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import jp.sourceforge.qrcode.codec.geom.Line;
import jp.sourceforge.qrcode.codec.geom.Point;

public class DebugCanvas
extends Canvas {
    BufferedImage image;
    static DebugCanvas instance;

    public void setFontColor(int color) {
    }

    public void paint(Graphics g) {
        if (this.image != null) {
            g.drawImage(this.image, 0, 0, Color.WHITE, null);
        }
    }

    DebugCanvas() {
    }

    public static DebugCanvas getCanvas() {
        if (instance == null) {
            instance = new DebugCanvas();
        }
        return instance;
    }

    public int getLineWidth() {
        return 0;
    }

    public void println(String string) {
        System.out.println(string);
    }

    public void println(int num) {
        System.out.println(num);
    }

    public void println(Object object) {
        System.out.println(object);
    }

    public void print(String string) {
        System.out.print(string);
    }

    public void print(Object object) {
        System.out.print(object);
    }

    public void drawMatrix(boolean[][] matrix) {
        if (this.image == null) {
            this.image = new BufferedImage(matrix.length, matrix[0].length, 2);
            this.setSize(matrix.length, matrix[0].length);
        }
        Graphics2D g2d = this.image.createGraphics();
        g2d.setColor(Color.WHITE);
        int width = this.getWidth();
        int x = 0;
        while (x < matrix.length) {
            g2d.drawLine(x, 0, x, width);
            ++x;
        }
        g2d.setColor(Color.BLACK);
        x = 0;
        while (x < matrix.length) {
            int y = 0;
            while (y < matrix[0].length) {
                if (matrix[x][y]) {
                    g2d.drawLine(x, y, x, y);
                }
                ++y;
            }
            ++x;
        }
        this.repaint();
    }

    public void drawMatrix(boolean[][] matrix, int ratio) {
    }

    public void drawLines(Line[] lines, int color) {
        Graphics2D g2d = this.image.createGraphics();
        g2d.setColor(this.convertColor(color));
        int i = 0;
        while (i < lines.length) {
            g2d.drawLine(lines[i].getP1().getX(), lines[i].getP1().getY(), lines[i].getP2().getX(), lines[i].getP2().getY());
            ++i;
        }
        this.repaint();
    }

    Color convertColor(int color) {
        Color awtColor = Color.BLACK;
        switch (color) {
            case 0xBBFFBB: {
                awtColor = Color.GREEN;
                break;
            }
            case 0xBBBBFF: {
                awtColor = Color.blue;
                break;
            }
            case 0xFFBBBB: {
                awtColor = Color.RED;
            }
        }
        return awtColor;
    }

    public void drawPolygon(Point[] points, int color) {
        Graphics2D g2d = this.image.createGraphics();
        g2d.setColor(this.convertColor(color));
        int numPoints = points.length;
        int[] polygonX = new int[numPoints];
        int[] polygonY = new int[numPoints];
        int i = 0;
        while (i < numPoints) {
            polygonX[i] = points[i].getX();
            polygonY[i] = points[i].getY();
            ++i;
        }
        g2d.drawPolygon(polygonX, polygonY, numPoints);
        this.repaint();
    }

    public void drawPoints(Point[] points, int color) {
        Graphics2D g2d = this.image.createGraphics();
        g2d.setColor(this.convertColor(color));
        int i = 0;
        while (i < points.length) {
            g2d.drawLine(points[i].getX(), points[i].getY(), points[i].getX(), points[i].getY());
            ++i;
        }
        this.repaint();
    }

    public void drawCross(Point point, int color) {
        Graphics2D g2d = this.image.createGraphics();
        g2d.setColor(this.convertColor(color));
        int x = point.getX();
        int y = point.getY();
        g2d.drawLine(x - 5, y, x + 5, y);
        g2d.drawLine(x, y - 5, x, y + 5);
        this.repaint();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }
}

