/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.codec.reader.pattern;

import java.util.Vector;
import jp.sourceforge.qrcode.codec.exception.FinderPatternNotFoundException;
import jp.sourceforge.qrcode.codec.exception.InvalidVersionInformationException;
import jp.sourceforge.qrcode.codec.exception.UnsupportedVersionException;
import jp.sourceforge.qrcode.codec.exception.VersionInformationException;
import jp.sourceforge.qrcode.codec.geom.Axis;
import jp.sourceforge.qrcode.codec.geom.Line;
import jp.sourceforge.qrcode.codec.geom.Point;
import jp.sourceforge.qrcode.codec.reader.QRCodeImageReader;
import jp.sourceforge.qrcode.codec.util.DebugCanvas;
import jp.sourceforge.qrcode.codec.util.QRCodeUtility;

public class FinderPattern {
    public static final int UL = 0;
    public static final int UR = 1;
    public static final int DL = 2;
    static final int[] VersionInfoBit = new int[]{31892, 34236, 39577, 42195, 48118, 51042, 55367, 58893, 63784, 68472, 70749, 76311, 79154, 84390, 87683, 92361, 96236, 102084, 102881, 110507, 110734, 117786, 119615, 126325, 127568, 133589, 136944, 141498, 145311, 150283, 152622, 158308, 161089, 167017};
    static DebugCanvas canvas = DebugCanvas.getCanvas();
    Point[] center;
    int version;
    int[] sincos;
    int[] width;
    int moduleSize;

    public static FinderPattern findFinderPattern(boolean[][] image) throws FinderPatternNotFoundException, VersionInformationException {
        Line[] lineAcross = FinderPattern.findLineAcross(image);
        Line[] lineCross = FinderPattern.findLineCross(lineAcross);
        Point[] center = null;
        center = FinderPattern.getCenter(lineCross);
        int[] sincos = FinderPattern.getAngle(center);
        center = FinderPattern.sort(center, sincos);
        int[] width = FinderPattern.getWidth(lineCross, center, sincos);
        int[] moduleSize = new int[]{(width[1] << QRCodeImageReader.DECIMAL_POINT) / 7, (width[2] << QRCodeImageReader.DECIMAL_POINT) / 7};
        int version = FinderPattern.calcRoughVersion(center, width);
        if (version > 6) {
            version = FinderPattern.calcExactVersion(center, sincos, moduleSize, image);
        }
        return new FinderPattern(center, version, sincos, width, moduleSize[0]);
    }

    FinderPattern(Point[] center, int version, int[] sincos, int[] width, int moduleSize) {
        this.center = center;
        this.version = version;
        this.sincos = sincos;
        this.width = width;
        this.moduleSize = moduleSize;
    }

    public Point[] getCenter() {
        return this.center;
    }

    public Point getCenter(int position) {
        if (position >= 0 && position <= 2) {
            return this.center[position];
        }
        return null;
    }

    public int getWidth(int position) {
        return this.width[position];
    }

    public int[] getAngle() {
        return this.sincos;
    }

    public int getVersion() {
        return this.version;
    }

    public int getModuleSize() {
        return this.moduleSize;
    }

    public int getSqrtNumModules() {
        return 17 + 4 * this.version;
    }

    static Line[] findLineAcross(boolean[][] image) {
        boolean READ_HORIZONTAL = false;
        boolean READ_VERTICAL = true;
        int imageWidth = image.length;
        int imageHeight = image[0].length;
        Point current = new Point();
        Vector<Line> lineAcross = new Vector<Line>();
        int[] lengthBuffer = new int[5];
        int bufferPointer = 0;
        boolean direction = false;
        boolean lastElement = false;
        while (true) {
            boolean currentElement;
            if ((currentElement = image[current.getX()][current.getY()]) == lastElement) {
                int n = bufferPointer;
                lengthBuffer[n] = lengthBuffer[n] + 1;
            } else {
                if (!currentElement && FinderPattern.checkPattern(lengthBuffer, bufferPointer)) {
                    int y1;
                    int y2;
                    int x2;
                    int j;
                    int x1;
                    if (!direction) {
                        x1 = current.getX();
                        j = 0;
                        while (j < 5) {
                            x1 -= lengthBuffer[j];
                            ++j;
                        }
                        x2 = current.getX() - 1;
                        y1 = y2 = current.getY();
                    } else {
                        x1 = x2 = current.getX();
                        y1 = current.getY();
                        j = 0;
                        while (j < 5) {
                            y1 -= lengthBuffer[j];
                            ++j;
                        }
                        y2 = current.getY() - 1;
                    }
                    lineAcross.addElement(new Line(x1, y1, x2, y2));
                }
                bufferPointer = (bufferPointer + 1) % 5;
                lengthBuffer[bufferPointer] = 1;
                boolean bl = lastElement = !lastElement;
            }
            if (!direction) {
                if (current.getX() < imageWidth - 1) {
                    current.translate(1, 0);
                    continue;
                }
                if (current.getY() < imageHeight - 1) {
                    current.set(0, current.getY() + 1);
                    lengthBuffer = new int[5];
                    continue;
                }
                current.set(0, 0);
                lengthBuffer = new int[5];
                direction = true;
                continue;
            }
            if (current.getY() < imageHeight - 1) {
                current.translate(0, 1);
                continue;
            }
            if (current.getX() >= imageWidth - 1) break;
            current.set(current.getX() + 1, 0);
            lengthBuffer = new int[5];
        }
        Line[] foundLines = new Line[lineAcross.size()];
        int i = 0;
        while (i < foundLines.length) {
            foundLines[i] = (Line)lineAcross.elementAt(i);
            ++i;
        }
        canvas.drawLines(foundLines, 0xBBFFBB);
        return foundLines;
    }

    static boolean checkPattern(int[] buffer, int pointer) {
        int[] modelRatio = new int[]{1, 1, 3, 1, 1};
        int baselength = 0;
        int i = 0;
        while (i < 5) {
            baselength += buffer[i];
            ++i;
        }
        baselength <<= QRCodeImageReader.DECIMAL_POINT;
        baselength /= 7;
        i = 0;
        while (i < 5) {
            int leastlength = baselength * modelRatio[i] - baselength / 2;
            int mostlength = baselength * modelRatio[i] + baselength / 2;
            int targetlength = buffer[(pointer + i + 1) % 5] << QRCodeImageReader.DECIMAL_POINT;
            if (targetlength < (leastlength -= baselength / 4) || targetlength > (mostlength += baselength / 4)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static Line[] findLineCross(Line[] lineAcross) {
        Vector crossLines = new Vector();
        Vector lineNeighbor = new Vector();
        Vector<Line> lineCandidate = new Vector<Line>();
        int i = 0;
        while (i < lineAcross.length) {
            lineCandidate.addElement(lineAcross[i]);
            ++i;
        }
        i = 0;
        while (i < lineCandidate.size() - 1) {
            lineNeighbor.removeAllElements();
            lineNeighbor.addElement(lineCandidate.elementAt(i));
            int j = i + 1;
            while (j < lineCandidate.size()) {
                int k;
                Line compareLine;
                if (Line.isNeighbor((Line)lineNeighbor.lastElement(), (Line)lineCandidate.elementAt(j))) {
                    lineNeighbor.addElement(lineCandidate.elementAt(j));
                    compareLine = (Line)lineNeighbor.lastElement();
                    if (lineNeighbor.size() * 5 > compareLine.getLength() && j == lineCandidate.size() - 1) {
                        crossLines.addElement(lineNeighbor.elementAt(lineNeighbor.size() / 2));
                        k = 0;
                        while (k < lineNeighbor.size()) {
                            lineCandidate.removeElement(lineNeighbor.elementAt(k));
                            ++k;
                        }
                    }
                } else if (FinderPattern.cantNeighbor((Line)lineNeighbor.lastElement(), (Line)lineCandidate.elementAt(j)) || j == lineCandidate.size() - 1) {
                    compareLine = (Line)lineNeighbor.lastElement();
                    if (lineNeighbor.size() * 6 <= compareLine.getLength()) break;
                    crossLines.addElement(lineNeighbor.elementAt(lineNeighbor.size() / 2));
                    k = 0;
                    while (k < lineNeighbor.size()) {
                        lineCandidate.removeElement(lineNeighbor.elementAt(k));
                        ++k;
                    }
                    break;
                }
                ++j;
            }
            ++i;
        }
        Line[] foundLines = new Line[crossLines.size()];
        int i2 = 0;
        while (i2 < foundLines.length) {
            foundLines[i2] = (Line)crossLines.elementAt(i2);
            ++i2;
        }
        return foundLines;
    }

    static boolean cantNeighbor(Line line1, Line line2) {
        if (Line.isCross(line1, line2)) {
            return true;
        }
        if (line1.isHorizontal()) {
            return Math.abs(line1.getP1().getY() - line2.getP1().getY()) > 1;
        }
        return Math.abs(line1.getP1().getX() - line2.getP1().getX()) > 1;
    }

    static int[] getAngle(Point[] centers) {
        Line[] additionalLine = new Line[3];
        int i = 0;
        while (i < additionalLine.length) {
            additionalLine[i] = new Line(centers[i], centers[(i + 1) % additionalLine.length]);
            ++i;
        }
        Line longestLine = Line.getLongest(additionalLine);
        Point originPoint = new Point();
        int i2 = 0;
        while (i2 < centers.length) {
            if ((centers[i2].getX() != longestLine.getP1().getX() || centers[i2].getY() != longestLine.getP1().getY()) & (centers[i2].getX() != longestLine.getP2().getX() || centers[i2].getY() != longestLine.getP2().getY())) {
                originPoint = centers[i2];
                break;
            }
            ++i2;
        }
        Point remotePoint = new Point();
        remotePoint = originPoint.getY() <= longestLine.getP1().getY() & originPoint.getY() <= longestLine.getP2().getY() ? (longestLine.getP1().getX() < longestLine.getP2().getX() ? longestLine.getP2() : longestLine.getP1()) : (originPoint.getX() >= longestLine.getP1().getX() & originPoint.getX() >= longestLine.getP2().getX() ? (longestLine.getP1().getY() < longestLine.getP2().getY() ? longestLine.getP2() : longestLine.getP1()) : (originPoint.getY() >= longestLine.getP1().getY() & originPoint.getY() >= longestLine.getP2().getY() ? (longestLine.getP1().getX() < longestLine.getP2().getX() ? longestLine.getP1() : longestLine.getP2()) : (longestLine.getP1().getY() < longestLine.getP2().getY() ? longestLine.getP1() : longestLine.getP2())));
        int r = new Line(originPoint, remotePoint).getLength();
        int[] sincos = new int[]{(remotePoint.getY() - originPoint.getY() << QRCodeImageReader.DECIMAL_POINT) / r, (remotePoint.getX() - originPoint.getX() << QRCodeImageReader.DECIMAL_POINT) / r};
        return sincos;
    }

    static Point[] getCenter(Line[] crossLines) throws FinderPatternNotFoundException {
        Vector<Point> centers = new Vector<Point>();
        int i = 0;
        while (i < crossLines.length - 1) {
            Line compareLine = crossLines[i];
            int j = i + 1;
            while (j < crossLines.length) {
                Line comparedLine = crossLines[j];
                if (Line.isCross(compareLine, comparedLine)) {
                    int x = 0;
                    int y = 0;
                    if (compareLine.isHorizontal()) {
                        x = compareLine.getCenter().getX();
                        y = comparedLine.getCenter().getY();
                    } else {
                        x = comparedLine.getCenter().getX();
                        y = compareLine.getCenter().getY();
                    }
                    centers.addElement(new Point(x, y));
                }
                ++j;
            }
            ++i;
        }
        Point[] foundPoints = new Point[centers.size()];
        int i2 = 0;
        while (i2 < foundPoints.length) {
            foundPoints[i2] = (Point)centers.elementAt(i2);
            ++i2;
        }
        if (foundPoints.length == 3) {
            canvas.drawPolygon(foundPoints, 0xFFBBBB);
            return foundPoints;
        }
        throw new FinderPatternNotFoundException();
    }

    static Point[] sort(Point[] centers, int[] sincos) {
        int sin = sincos[0];
        int cos = sincos[1];
        Point[] sortedCenters = new Point[3];
        int quadant = FinderPattern.getURQuadant(sincos);
        switch (quadant) {
            case 1: {
                sortedCenters[1] = FinderPattern.getPointAtSide(centers, 1, 2);
                sortedCenters[2] = FinderPattern.getPointAtSide(centers, 2, 4);
                break;
            }
            case 2: {
                sortedCenters[1] = FinderPattern.getPointAtSide(centers, 2, 4);
                sortedCenters[2] = FinderPattern.getPointAtSide(centers, 8, 4);
                break;
            }
            case 3: {
                sortedCenters[1] = FinderPattern.getPointAtSide(centers, 4, 8);
                sortedCenters[2] = FinderPattern.getPointAtSide(centers, 1, 8);
                break;
            }
            case 4: {
                sortedCenters[1] = FinderPattern.getPointAtSide(centers, 8, 1);
                sortedCenters[2] = FinderPattern.getPointAtSide(centers, 2, 1);
            }
        }
        int i = 0;
        while (i < centers.length) {
            if (!centers[i].equals(sortedCenters[1]) && !centers[i].equals(sortedCenters[2])) {
                sortedCenters[0] = centers[i];
            }
            ++i;
        }
        return sortedCenters;
    }

    static int getURQuadant(int[] sincos) {
        int sin = sincos[0];
        int cos = sincos[1];
        if (sin >= 0 && cos > 0) {
            return 1;
        }
        if (sin > 0 && cos <= 0) {
            return 2;
        }
        if (sin <= 0 && cos < 0) {
            return 3;
        }
        if (sin < 0 && cos >= 0) {
            return 4;
        }
        return 0;
    }

    static Point getPointAtSide(Point[] points, int side1, int side2) {
        Point sidePoint = new Point();
        int x = side1 == 1 || side2 == 1 ? 0 : Integer.MAX_VALUE;
        int y = side1 == 2 || side2 == 2 ? 0 : Integer.MAX_VALUE;
        sidePoint = new Point(x, y);
        int i = 0;
        while (i < points.length) {
            switch (side1) {
                case 1: {
                    if (sidePoint.getX() < points[i].getX()) {
                        sidePoint = points[i];
                        break;
                    }
                    if (sidePoint.getX() != points[i].getX()) break;
                    if (side2 == 2) {
                        if (sidePoint.getY() >= points[i].getY()) break;
                        sidePoint = points[i];
                        break;
                    }
                    if (sidePoint.getY() <= points[i].getY()) break;
                    sidePoint = points[i];
                    break;
                }
                case 2: {
                    if (sidePoint.getY() < points[i].getY()) {
                        sidePoint = points[i];
                        break;
                    }
                    if (sidePoint.getY() != points[i].getY()) break;
                    if (side2 == 1) {
                        if (sidePoint.getX() >= points[i].getX()) break;
                        sidePoint = points[i];
                        break;
                    }
                    if (sidePoint.getX() <= points[i].getX()) break;
                    sidePoint = points[i];
                    break;
                }
                case 4: {
                    if (sidePoint.getX() > points[i].getX()) {
                        sidePoint = points[i];
                        break;
                    }
                    if (sidePoint.getX() != points[i].getX()) break;
                    if (side2 == 2) {
                        if (sidePoint.getY() >= points[i].getY()) break;
                        sidePoint = points[i];
                        break;
                    }
                    if (sidePoint.getY() <= points[i].getY()) break;
                    sidePoint = points[i];
                    break;
                }
                case 8: {
                    if (sidePoint.getY() > points[i].getY()) {
                        sidePoint = points[i];
                        break;
                    }
                    if (sidePoint.getY() != points[i].getY()) break;
                    if (side2 == 1) {
                        if (sidePoint.getX() >= points[i].getX()) break;
                        sidePoint = points[i];
                        break;
                    }
                    if (sidePoint.getX() <= points[i].getX()) break;
                    sidePoint = points[i];
                }
            }
            ++i;
        }
        return sidePoint;
    }

    static int[] getWidth(Line[] crossLines, Point[] centers, int[] sincos) {
        int sin = sincos[0];
        int cos = sincos[1];
        int[] width = new int[3];
        int i = 0;
        while (i < crossLines.length) {
            int j = i;
            while (j < crossLines.length) {
                if (Line.isCross(crossLines[i], crossLines[j])) {
                    int r;
                    int y;
                    int k;
                    if (crossLines[i].isHorizontal()) {
                        k = 0;
                        while (k < centers.length) {
                            if (crossLines[i].getCenter().getX() == centers[k].getX() && crossLines[j].getCenter().getY() == centers[k].getY()) {
                                y = 0;
                                y = Math.abs(sin) < (1 << QRCodeImageReader.DECIMAL_POINT) / 2 ? crossLines[i].getLength() * sin >> QRCodeImageReader.DECIMAL_POINT : crossLines[i].getLength() * cos >> QRCodeImageReader.DECIMAL_POINT;
                                r = crossLines[i].getLength();
                                width[k] = QRCodeUtility.sqrt(r * r - y * y);
                            }
                            ++k;
                        }
                    } else {
                        k = 0;
                        while (k < centers.length) {
                            if (crossLines[j].getCenter().getX() == centers[k].getX() && crossLines[i].getCenter().getY() == centers[k].getY()) {
                                y = 0;
                                y = Math.abs(sin) < 2897 ? crossLines[i].getLength() * sin >> 12 : crossLines[i].getLength() * cos >> 12;
                                r = crossLines[j].getLength();
                                width[k] = QRCodeUtility.sqrt(r * r - y * y);
                            }
                            ++k;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return width;
    }

    static int calcRoughVersion(Point[] center, int[] width) {
        int dp = QRCodeImageReader.DECIMAL_POINT;
        int lengthAdditionalLine = new Line(center[0], center[1]).getLength() << dp;
        int avarageWidth = (width[0] + width[1] << dp) / 14;
        int roughVersion = (lengthAdditionalLine / avarageWidth - 10) / 4;
        if ((lengthAdditionalLine / avarageWidth - 10) % 4 >= 2) {
            ++roughVersion;
        }
        return roughVersion;
    }

    /*
     * Unable to fully structure code
     */
    static int calcExactVersion(Point[] centers, int[] sincos, int[] moduleSize, boolean[][] image) throws InvalidVersionInformationException, UnsupportedVersionException {
        block8: {
            versionInformation = new boolean[18];
            points = new Point[18];
            sin = sincos[0];
            cos = sincos[1];
            axis = new Axis(sin, cos, moduleSize[0]);
            axis.setOrigin(centers[1]);
            y = 0;
            while (y < 6) {
                x = 0;
                while (x < 3) {
                    targetX = axis.translate(x - 7, 0).getX() + 1;
                    targetY = axis.translate(0, y - 3).getY() + 1;
                    versionInformation[x + y * 3] = image[targetX][targetY];
                    points[x + y * 3] = new Point(targetX, targetY);
                    ++x;
                }
                ++y;
            }
            FinderPattern.canvas.drawPoints(points, 0xFFBBBB);
            exactVersion = 0;
            try {
                exactVersion = FinderPattern.checkVersionInfo(versionInformation);
                break block8;
            }
            catch (VersionInformationException e) {
                FinderPattern.canvas.println("Version info error. now retry with other place one.");
                axis.setOrigin(centers[2]);
                axis.setModulePitch(moduleSize[1]);
                x = 0;
                ** while (x < 6)
            }
lbl-1000:
            // 1 sources

            {
                y = 0;
                while (y < 3) {
                    targetX = axis.translate(x - 3, 0).getX();
                    targetY = axis.translate(0, y - 7).getY();
                    versionInformation[y + x * 3] = image[targetX][targetY];
                    points[x + y * 3] = new Point(targetX, targetY);
                    ++y;
                }
                ++x;
                continue;
            }
lbl40:
            // 1 sources

            FinderPattern.canvas.drawPoints(points, 0xFFBBBB);
            try {
                exactVersion = FinderPattern.checkVersionInfo(versionInformation);
            }
            catch (VersionInformationException e2) {
                e.printStackTrace();
                throw e2;
            }
        }
        return exactVersion;
    }

    static int checkVersionInfo(boolean[] target) throws InvalidVersionInformationException {
        int errorCount = 0;
        int versionBase = 0;
        while (versionBase < VersionInfoBit.length) {
            errorCount = 0;
            int j = 0;
            while (j < 18) {
                if (target[j] ^ (VersionInfoBit[versionBase] >> j) % 2 == 1) {
                    ++errorCount;
                }
                ++j;
            }
            if (errorCount <= 3) break;
            ++versionBase;
        }
        if (errorCount <= 3) {
            return 7 + versionBase;
        }
        throw new InvalidVersionInformationException();
    }
}

