/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.codec.reader.pattern;

import jp.sourceforge.qrcode.codec.exception.AlignmentPatternEdgeNotFoundException;
import jp.sourceforge.qrcode.codec.geom.Axis;
import jp.sourceforge.qrcode.codec.geom.Line;
import jp.sourceforge.qrcode.codec.geom.Point;
import jp.sourceforge.qrcode.codec.reader.pattern.FinderPattern;
import jp.sourceforge.qrcode.codec.util.DebugCanvas;

public class AlignmentPattern {
    static final int RIGHT = 1;
    static final int BOTTOM = 2;
    static final int LEFT = 3;
    static final int TOP = 4;
    static DebugCanvas canvas = DebugCanvas.getCanvas();
    Point[][] center;
    int patternDistance;

    AlignmentPattern(Point[][] center, int patternDistance) {
        this.center = center;
        this.patternDistance = patternDistance;
    }

    public static AlignmentPattern findAlignmentPattern(boolean[][] image, FinderPattern finderPattern) throws AlignmentPatternEdgeNotFoundException {
        Point[][] logicalCenters = AlignmentPattern.getLogicalCenter(finderPattern);
        int logicalDistance = logicalCenters[1][0].getX() - logicalCenters[0][0].getX();
        Point[][] centers = null;
        try {
            centers = AlignmentPattern.getCenter(image, finderPattern, logicalCenters);
        }
        catch (AlignmentPatternEdgeNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        return new AlignmentPattern(centers, logicalDistance);
    }

    public Point[][] getCenter() {
        return this.center;
    }

    public int getLogicalDistance() {
        return this.patternDistance;
    }

    static Point[][] getCenter(boolean[][] image, FinderPattern finderPattern, Point[][] logicalCenters) throws AlignmentPatternEdgeNotFoundException {
        int moduleSize = finderPattern.getModuleSize();
        int sin = finderPattern.getAngle()[0];
        int cos = finderPattern.getAngle()[1];
        Axis axis = new Axis(sin, cos, moduleSize);
        int sqrtCenters = logicalCenters.length;
        Point[][] centers = new Point[sqrtCenters][sqrtCenters];
        axis.setOrigin(finderPattern.getCenter(0));
        centers[0][0] = axis.translate(3, 3);
        axis.setOrigin(finderPattern.getCenter(1));
        centers[sqrtCenters - 1][0] = axis.translate(-3, 3);
        axis.setOrigin(finderPattern.getCenter(2));
        centers[0][sqrtCenters - 1] = axis.translate(3, -3);
        int y = 0;
        while (y < sqrtCenters) {
            int x = 0;
            while (x < sqrtCenters) {
                block8: {
                    block6: {
                        block7: {
                            block5: {
                                if (x != 1 || y != 0 || sqrtCenters != 3) break block5;
                                centers[x][y] = Point.getCenter(centers[0][0], centers[sqrtCenters - 1][0]);
                                break block6;
                            }
                            if (x != 0 || y != 1 || sqrtCenters != 3) break block7;
                            centers[x][y] = Point.getCenter(centers[0][0], centers[0][sqrtCenters - 1]);
                            break block6;
                        }
                        if (x < 1 || y < 1) break block8;
                        Line[] additionalLines = new Line[]{new Line(centers[x - 1][y - 1], centers[x][y - 1]), new Line(centers[x - 1][y - 1], centers[x - 1][y])};
                        int dx = centers[x - 1][y].getX() - centers[x - 1][y - 1].getX();
                        int dy = centers[x - 1][y].getY() - centers[x - 1][y - 1].getY();
                        additionalLines[0].translate(dx, dy);
                        dx = centers[x][y - 1].getX() - centers[x - 1][y - 1].getX();
                        dy = centers[x][y - 1].getY() - centers[x - 1][y - 1].getY();
                        additionalLines[1].translate(dx, dy);
                        centers[x][y] = Point.getCenter(additionalLines[0].getP2(), additionalLines[1].getP2());
                    }
                    try {
                        centers[x][y] = AlignmentPattern.getPrecisionCenter(image, centers[x][y]);
                    }
                    catch (AlignmentPatternEdgeNotFoundException e) {
                        e.printStackTrace();
                        throw e;
                    }
                    canvas.drawCross(centers[x][y], 0xFFBBBB);
                }
                ++x;
            }
            ++y;
        }
        return centers;
    }

    static Point getPrecisionCenter(boolean[][] image, Point targetPoint) throws AlignmentPatternEdgeNotFoundException {
        if (!image[targetPoint.getX()][targetPoint.getY()]) {
            int scope = 0;
            boolean notFound = true;
            while (notFound) {
                int dy = ++scope;
                while (dy > -scope) {
                    int dx = scope;
                    while (dx > -scope) {
                        if (image[targetPoint.getX() + dx][targetPoint.getY() + dy]) {
                            targetPoint = new Point(targetPoint.getX() + dx, targetPoint.getY() + dy);
                            notFound = false;
                        }
                        --dx;
                    }
                    --dy;
                }
            }
        }
        Point pointEdgeRight = null;
        Point pointEdgeBottom = null;
        Point pointEdgeLeft = null;
        Point pointEdgeTop = null;
        try {
            pointEdgeRight = AlignmentPattern.getEdge(image, targetPoint, 1);
            pointEdgeBottom = AlignmentPattern.getEdge(image, targetPoint, 2);
            pointEdgeLeft = AlignmentPattern.getEdge(image, targetPoint, 3);
            pointEdgeTop = AlignmentPattern.getEdge(image, targetPoint, 4);
        }
        catch (AlignmentPatternEdgeNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        int x = Point.getCenter(pointEdgeLeft, pointEdgeRight).getX();
        int y = Point.getCenter(pointEdgeTop, pointEdgeBottom).getY();
        return new Point(x, y);
    }

    static Point[][] getLogicalCenter(FinderPattern finderPattern) {
        int version = finderPattern.getVersion();
        Point[][] logicalCenters = new Point[1][1];
        int[] logicalSeeds = new int[1];
        if (version == 1) {
            return null;
        }
        if (version >= 2 && version <= 6) {
            logicalSeeds = new int[]{6, 10 + 4 * version};
            logicalCenters = new Point[logicalSeeds.length][logicalSeeds.length];
        } else if (version >= 7 && version <= 13) {
            logicalSeeds = new int[]{6, 8 + 2 * version, 10 + 4 * version};
            logicalCenters = new Point[logicalSeeds.length][logicalSeeds.length];
        }
        int col = 0;
        while (col < logicalCenters.length) {
            int row = 0;
            while (row < logicalCenters.length) {
                logicalCenters[row][col] = new Point(logicalSeeds[row], logicalSeeds[col]);
                ++row;
            }
            ++col;
        }
        return logicalCenters;
    }

    static Point getEdge(boolean[][] image, Point startPoint, int direction) throws AlignmentPatternEdgeNotFoundException {
        int imageWidth = image.length;
        int imageHeight = image[0].length;
        int targetX = startPoint.getX();
        int targetY = startPoint.getY();
        boolean currentElement = true;
        boolean lastElement = true;
        int dx = 0;
        int dy = 0;
        if (direction == 1) {
            dx = 1;
        } else if (direction == 2) {
            dy = 1;
        } else if (direction == 3) {
            dx = -1;
        } else if (direction == 4) {
            dy = -1;
        }
        do {
            currentElement = image[targetX][targetY];
            if (!lastElement && currentElement) {
                return new Point(targetX - dx, targetY - dy);
            }
            lastElement = currentElement;
        } while ((targetX += dx) >= 0 && targetX < imageWidth && (targetY += dy) >= 0 && targetY < imageHeight);
        throw new AlignmentPatternEdgeNotFoundException();
    }
}

